/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.scm.providers.svn.settings.Settings;
import org.apache.maven.scm.providers.svn.settings.io.xpp3.SvnXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class SvnUtil {
    protected static final String SVN_SETTINGS_FILENAME = "svn-settings.xml";
    public static final File DEFAULT_SETTINGS_DIRECTORY;
    private static File settingsDirectory;

    private SvnUtil() {
    }

    public static Settings getSettings() {
        File scmUserDir = settingsDirectory;
        File settingsFile = new File(scmUserDir, SVN_SETTINGS_FILENAME);
        if (settingsFile.exists()) {
            SvnXpp3Reader reader = new SvnXpp3Reader();
            try {
                return reader.read((Reader)ReaderFactory.newXmlReader((File)settingsFile));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            catch (XmlPullParserException e) {
                String message = settingsFile.getAbsolutePath() + " isn't well formed. SKIPPED." + e.getMessage();
                System.err.println(message);
            }
        }
        return new Settings();
    }

    public static void setSettingsDirectory(File directory) {
        settingsDirectory = directory;
    }

    static {
        settingsDirectory = DEFAULT_SETTINGS_DIRECTORY = new File(System.getProperty("user.home"), ".scm");
    }
}

