/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.edit;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.edit.AbstractEditCommand;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.edit.PerforceEditConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerforceEditCommand
extends AbstractEditCommand
implements PerforceCommand {
    protected ScmResult executeEditCommand(ScmProviderRepository repo, ScmFileSet files) throws ScmException {
        PerforceEditConsumer consumer;
        Commandline cl;
        block5: {
            cl = PerforceEditCommand.createCommandLine((PerforceScmProviderRepository)repo, files.getBasedir(), files);
            consumer = new PerforceEditConsumer();
            try {
                CommandLineUtils.StringStreamConsumer err;
                int exitCode;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(PerforceScmProvider.clean("Executing " + cl.toString()));
                }
                if ((exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)(err = new CommandLineUtils.StringStreamConsumer()))) != 0) {
                    String cmdLine = CommandLineUtils.toString((String[])cl.getCommandline());
                    StringBuilder msg = new StringBuilder("Exit code: " + exitCode + " - " + err.getOutput());
                    msg.append('\n');
                    msg.append("Command line was:" + cmdLine);
                    throw new CommandLineException(msg.toString());
                }
            }
            catch (CommandLineException e) {
                if (!this.getLogger().isErrorEnabled()) break block5;
                this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
            }
        }
        if (consumer.isSuccess()) {
            return new EditScmResult(cl.toString(), consumer.getEdits());
        }
        return new EditScmResult(cl.toString(), "Unable to edit file(s)", consumer.getErrorMessage(), false);
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, ScmFileSet files) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArg().setValue("edit");
        try {
            String candir = workingDirectory.getCanonicalPath();
            List fs = files.getFileList();
            for (int i = 0; i < fs.size(); ++i) {
                File file = new File(workingDirectory, ((File)fs.get(i)).getPath());
                String canfile = file.getCanonicalPath();
                if (canfile.startsWith(candir)) {
                    canfile = canfile.substring(candir.length() + 1);
                }
                command.createArg().setValue(canfile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return command;
    }
}

