/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.blame;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.blame.AbstractBlameCommand;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.command.blame.BlameScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.blame.PerforceBlameConsumer;
import org.apache.maven.scm.provider.perforce.command.blame.PerforceFilelogConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerforceBlameCommand
extends AbstractBlameCommand
implements PerforceCommand {
    public BlameScmResult executeBlameCommand(ScmProviderRepository repo, ScmFileSet workingDirectory, String filename) throws ScmException {
        int exitCode;
        Commandline cl = PerforceBlameCommand.createCommandLine((PerforceScmProviderRepository)repo, workingDirectory.getBasedir(), filename);
        PerforceBlameConsumer blameConsumer = new PerforceBlameConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)blameConsumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new BlameScmResult(cl.toString(), "The perforce command failed.", stderr.getOutput(), false);
        }
        cl = PerforceBlameCommand.createFilelogCommandLine((PerforceScmProviderRepository)repo, workingDirectory.getBasedir(), filename);
        PerforceFilelogConsumer filelogConsumer = new PerforceFilelogConsumer(this.getLogger());
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)filelogConsumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new BlameScmResult(cl.toString(), "The perforce command failed.", stderr.getOutput(), false);
        }
        List<BlameLine> lines = blameConsumer.getLines();
        for (int i = 0; i < lines.size(); ++i) {
            BlameLine line = lines.get(i);
            String revision = line.getRevision();
            line.setAuthor(filelogConsumer.getAuthor(revision));
            line.setDate(filelogConsumer.getDate(revision));
        }
        return new BlameScmResult(cl.toString(), lines);
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, String filename) {
        Commandline cl = PerforceScmProvider.createP4Command(repo, workingDirectory);
        cl.createArg().setValue("annotate");
        cl.createArg().setValue("-q");
        cl.createArg().setValue(filename);
        return cl;
    }

    public static Commandline createFilelogCommandLine(PerforceScmProviderRepository repo, File workingDirectory, String filename) {
        Commandline cl = PerforceScmProvider.createP4Command(repo, workingDirectory);
        cl.createArg().setValue("filelog");
        cl.createArg().setValue(filename);
        return cl;
    }
}

