/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.login;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.login.AbstractLoginCommand;
import org.apache.maven.scm.command.login.LoginScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.login.PerforceLoginConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceLoginCommand
extends AbstractLoginCommand
implements PerforceCommand {
    public LoginScmResult executeLoginCommand(ScmProviderRepository repo, ScmFileSet files, CommandParameters params) throws ScmException {
        Commandline cl = PerforceLoginCommand.createCommandLine((PerforceScmProviderRepository)repo, files.getBasedir());
        PerforceLoginConsumer consumer = new PerforceLoginConsumer();
        try {
            Process proc = cl.execute();
            DataOutputStream dos = new DataOutputStream(proc.getOutputStream());
            if (StringUtils.isEmpty((String)repo.getPassword())) {
                throw new ScmException("password is required for the perforce scm plugin.");
            }
            dos.writeUTF(repo.getPassword());
            dos.close();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                this.getLogger().debug("Consuming: " + line);
                consumer.consumeLine(line);
            }
            BufferedReader brErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            while ((line = brErr.readLine()) != null) {
                this.getLogger().debug("Consuming stderr: " + line);
                consumer.consumeLine(line);
            }
            brErr.close();
        }
        catch (CommandLineException e) {
            throw new ScmException("", (Throwable)e);
        }
        catch (IOException e) {
            throw new ScmException("", (Throwable)e);
        }
        return new LoginScmResult(cl.toString(), consumer.isSuccess() ? "Login successful" : "Login failed", consumer.getOutput(), consumer.isSuccess());
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDir) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDir);
        command.createArgument().setValue("login");
        if (!StringUtils.isEmpty((String)repo.getUser())) {
            command.createArgument().setValue(repo.getUser());
        }
        return command;
    }
}

