/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.local.command.changelog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.local.repository.LocalScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;

public class LocalChangeLogCommand
extends AbstractChangeLogCommand {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repository, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern) throws ScmException {
        LocalScmProviderRepository repo = (LocalScmProviderRepository)repository;
        if (branch != null) {
            throw new ScmException("The local scm doesn't support tags.");
        }
        File root = new File(repo.getRoot());
        String module = repo.getModule();
        File source = new File(root, module);
        File baseDestination = fileSet.getBasedir();
        if (!baseDestination.exists()) {
            throw new ScmException("The working directory doesn't exist (" + baseDestination.getAbsolutePath() + ").");
        }
        if (!root.exists()) {
            throw new ScmException("The base directory doesn't exist (" + root.getAbsolutePath() + ").");
        }
        if (!source.exists()) {
            throw new ScmException("The module directory doesn't exist (" + source.getAbsolutePath() + ").");
        }
        ArrayList<ChangeSet> changeLogList = new ArrayList<ChangeSet>();
        try {
            File repoRoot = new File(repo.getRoot(), repo.getModule());
            List files = fileSet.getFileList();
            if (files.isEmpty()) {
                files = FileUtils.getFiles((File)baseDestination, (String)"**", null, (boolean)false);
            }
            for (File file : files) {
                String path = file.getPath().replace('\\', '/');
                File repoFile = new File(repoRoot, path);
                file = new File(baseDestination, path);
                ChangeSet changeSet = new ChangeSet();
                int chop = repoRoot.getAbsolutePath().length();
                String fileName = "/" + repoFile.getAbsolutePath().substring(chop + 1);
                changeSet.addFile(new ChangeFile(fileName, null));
                if (repoFile.exists()) {
                    long lastModified = repoFile.lastModified();
                    Date modifiedDate = new Date(lastModified);
                    if (startDate != null && (!startDate.before(modifiedDate) && !startDate.equals(modifiedDate) || endDate != null && !endDate.after(modifiedDate) && !endDate.equals(modifiedDate))) continue;
                    changeSet.setDate(modifiedDate);
                    changeLogList.add(changeSet);
                    continue;
                }
                changeLogList.add(changeSet);
            }
        }
        catch (IOException ex) {
            throw new ScmException("Error while getting change logs.", (Throwable)ex);
        }
        return new ChangeLogScmResult(null, new ChangeLogSet(changeLogList, startDate, endDate));
    }
}

