/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.diff;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.diff.AbstractDiffCommand;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.command.diff.GitDiffConsumer;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;

public class JGitDiffCommand
extends AbstractDiffCommand
implements GitCommand {
    protected DiffScmResult executeDiffCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion startRevision, ScmVersion endRevision) throws ScmException {
        Git git = null;
        try {
            git = Git.open((File)fileSet.getBasedir());
            DiffScmResult diff = this.callDiff(git, startRevision, endRevision);
            git.getRepository().close();
            DiffScmResult diffScmResult = diff;
            return diffScmResult;
        }
        catch (Exception e) {
            throw new ScmException("JGit diff failure!", (Throwable)e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }

    public DiffScmResult callDiff(Git git, ScmVersion startRevision, ScmVersion endRevision) throws IOException, GitAPIException, ScmException {
        String[] lines;
        AbstractTreeIterator oldTree = null;
        if (startRevision != null && StringUtils.isNotEmpty((String)startRevision.getName().trim())) {
            String startRev = startRevision.getName().trim();
            oldTree = this.getTreeIterator(git.getRepository(), startRev);
        }
        AbstractTreeIterator newTree = null;
        if (endRevision != null && StringUtils.isNotEmpty((String)endRevision.getName().trim())) {
            String endRev = endRevision.getName().trim();
            newTree = this.getTreeIterator(git.getRepository(), endRev);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        git.diff().setOutputStream((OutputStream)out).setOldTree(oldTree).setNewTree(newTree).setCached(false).call();
        git.diff().setOutputStream((OutputStream)out).setOldTree(oldTree).setNewTree(newTree).setCached(true).call();
        out.flush();
        GitDiffConsumer consumer = new GitDiffConsumer(this.getLogger(), null);
        String fullDiff = ((Object)out).toString();
        ((OutputStream)out).close();
        for (String aLine : lines = fullDiff.split("\n")) {
            consumer.consumeLine(aLine);
        }
        return new DiffScmResult("JGit diff", consumer.getChangedFiles(), consumer.getDifferences(), consumer.getPatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractTreeIterator getTreeIterator(Repository repo, String name) throws IOException {
        ObjectId id = repo.resolve(name);
        if (id == null) {
            throw new IllegalArgumentException(name);
        }
        CanonicalTreeParser p = new CanonicalTreeParser();
        ObjectReader or = repo.newObjectReader();
        try {
            p.reset(or, (AnyObjectId)new RevWalk(repo).parseTree((AnyObjectId)id));
            CanonicalTreeParser canonicalTreeParser = p;
            return canonicalTreeParser;
        }
        finally {
            or.release();
        }
    }
}

