/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command.branch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmBranchParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.Command;
import org.apache.maven.scm.command.branch.AbstractBranchCommand;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.apache.maven.scm.provider.hg.command.inventory.HgListConsumer;
import org.apache.maven.scm.provider.hg.repository.HgScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;

public class HgBranchCommand
extends AbstractBranchCommand
implements Command {
    protected ScmResult executeBranchCommand(ScmProviderRepository scmProviderRepository, ScmFileSet fileSet, String branch, String message) throws ScmException {
        return this.executeBranchCommand(scmProviderRepository, fileSet, branch, new ScmBranchParameters(message));
    }

    protected ScmResult executeBranchCommand(ScmProviderRepository scmProviderRepository, ScmFileSet fileSet, String branch, ScmBranchParameters scmBranchParameters) throws ScmException {
        if (StringUtils.isBlank((String)branch)) {
            throw new ScmException("branch must be specified");
        }
        if (!fileSet.getFileList().isEmpty()) {
            throw new ScmException("This provider doesn't support branchging subsets of a directory");
        }
        File workingDir = fileSet.getBasedir();
        String[] branchCmd = new String[]{"branch", branch};
        HgConsumer branchConsumer = new HgConsumer(){

            @Override
            public void doConsume(ScmFileStatus status, String trimmedLine) {
            }
        };
        ScmResult result = HgUtils.execute(branchConsumer, workingDir, branchCmd);
        HgScmProviderRepository repository = (HgScmProviderRepository)scmProviderRepository;
        if (!result.isSuccess()) {
            throw new ScmException("Error while executing command " + this.joinCmd(branchCmd));
        }
        String[] commitCmd = new String[]{"commit", "--message", scmBranchParameters.getMessage()};
        result = HgUtils.execute(new HgConsumer(), workingDir, commitCmd);
        if (!result.isSuccess()) {
            throw new ScmException("Error while executing command " + this.joinCmd(commitCmd));
        }
        if (repository.isPushChanges() && !repository.getURI().equals(fileSet.getBasedir().getAbsolutePath())) {
            String[] pushCmd = new String[]{"push", "--new-branch", repository.getURI()};
            result = HgUtils.execute(new HgConsumer(), fileSet.getBasedir(), pushCmd);
            if (!result.isSuccess()) {
                throw new ScmException("Error while executing command " + this.joinCmd(pushCmd));
            }
        }
        String[] listCmd = new String[]{"locate"};
        HgListConsumer listconsumer = new HgListConsumer();
        result = HgUtils.execute(listconsumer, fileSet.getBasedir(), listCmd);
        if (!result.isSuccess()) {
            throw new ScmException("Error while executing command " + this.joinCmd(listCmd));
        }
        List<ScmFile> files = listconsumer.getFiles();
        ArrayList<ScmFile> fileList = new ArrayList<ScmFile>();
        for (ScmFile f : files) {
            fileList.add(new ScmFile(f.getPath(), ScmFileStatus.TAGGED));
        }
        return new BranchScmResult(fileList, result);
    }

    private String joinCmd(String[] cmd) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < cmd.length; ++i) {
            String s = cmd[i];
            result.append(s);
            if (i >= cmd.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }
}

