/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.status;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.status.AbstractStatusCommand;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.status.GitStatusConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class GitStatusCommand
extends AbstractStatusCommand
implements GitCommand {
    protected StatusScmResult executeStatusCommand(ScmProviderRepository repo, ScmFileSet fileSet) throws ScmException {
        CommandLineUtils.StringStreamConsumer stderr;
        GitStatusConsumer consumer;
        Commandline cl = GitStatusCommand.createCommandLine((GitScmProviderRepository)repo, fileSet);
        int exitCode = GitCommandLineUtils.execute(cl, consumer = new GitStatusConsumer(this.getLogger(), fileSet.getBasedir()), stderr = new CommandLineUtils.StringStreamConsumer(), this.getLogger());
        if (exitCode != 0 && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("nothing added to commit but untracked files present (use \"git add\" to track)");
        }
        return new StatusScmResult(cl.toString(), consumer.getChangedFiles());
    }

    public static Commandline createCommandLine(GitScmProviderRepository repository, ScmFileSet fileSet) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "status");
        cl.addArguments(new String[]{"--porcelain"});
        return cl;
    }
}

