/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitCommandLineUtils {
    public static void addTarget(Commandline cl, List<File> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        for (File f : files) {
            String relativeFile = f.getPath();
            if (f.getAbsolutePath().startsWith(cl.getWorkingDirectory().getAbsolutePath()) && (relativeFile = f.getAbsolutePath().substring(cl.getWorkingDirectory().getAbsolutePath().length())).startsWith(File.separator)) {
                relativeFile = relativeFile.substring(File.separator.length());
            }
            cl.createArg().setValue(relativeFile);
        }
    }

    public static Commandline getBaseGitCommandLine(File workingDirectory, String command) {
        if (command == null || command.length() == 0) {
            return null;
        }
        Commandline cl = new Commandline();
        cl.setExecutable("git");
        cl.createArg().setValue(command);
        cl.setWorkingDirectory(workingDirectory.getAbsolutePath());
        return cl;
    }

    public static int execute(Commandline cl, StreamConsumer consumer, CommandLineUtils.StringStreamConsumer stderr, ScmLogger logger) throws ScmException {
        int exitCode;
        if (logger.isInfoEnabled()) {
            logger.info("Executing: " + cl);
            logger.info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        }
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        return exitCode;
    }

    public static int execute(Commandline cl, CommandLineUtils.StringStreamConsumer stdout, CommandLineUtils.StringStreamConsumer stderr, ScmLogger logger) throws ScmException {
        int exitCode;
        if (logger.isInfoEnabled()) {
            logger.info("Executing: " + cl);
            logger.info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        }
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        return exitCode;
    }
}

