/*
 * $Id$
 */

package org.apache.maven.scm.providers.clearcase.settings;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class Settings.
 * 
 * @version $Revision$ $Date$
 */
public class Settings implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Clearcase viewstore path.
     */
    private String viewstore;

    /**
     * Do you want to use vws parameter when clearcase provider run
     * mkview?
     */
    private boolean useVWSParameter = true;

    /**
     * Are you using ClearCase LT or UCM version ?
     */
    private String clearcaseType;

    /**
     * The format of the USER pattern in lhistory command. For
     * example, it can be "-8.8".
     */
    private String changelogUserFormat;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the format of the USER pattern in lhistory command. For
     * example, it can be "-8.8".
     * 
     * @return String
     */
    public String getChangelogUserFormat()
    {
        return this.changelogUserFormat;
    } //-- String getChangelogUserFormat() 

    /**
     * Get are you using ClearCase LT or UCM version ?
     * 
     * @return String
     */
    public String getClearcaseType()
    {
        return this.clearcaseType;
    } //-- String getClearcaseType() 

    /**
     * Get clearcase viewstore path.
     * 
     * @return String
     */
    public String getViewstore()
    {
        return this.viewstore;
    } //-- String getViewstore() 

    /**
     * Get do you want to use vws parameter when clearcase provider
     * run mkview?
     * 
     * @return boolean
     */
    public boolean isUseVWSParameter()
    {
        return this.useVWSParameter;
    } //-- boolean isUseVWSParameter() 

    /**
     * Set the format of the USER pattern in lhistory command. For
     * example, it can be "-8.8".
     * 
     * @param changelogUserFormat
     */
    public void setChangelogUserFormat(String changelogUserFormat)
    {
        this.changelogUserFormat = changelogUserFormat;
    } //-- void setChangelogUserFormat(String) 

    /**
     * Set are you using ClearCase LT or UCM version ?
     * 
     * @param clearcaseType
     */
    public void setClearcaseType(String clearcaseType)
    {
        this.clearcaseType = clearcaseType;
    } //-- void setClearcaseType(String) 

    /**
     * Set do you want to use vws parameter when clearcase provider
     * run mkview?
     * 
     * @param useVWSParameter
     */
    public void setUseVWSParameter(boolean useVWSParameter)
    {
        this.useVWSParameter = useVWSParameter;
    } //-- void setUseVWSParameter(boolean) 

    /**
     * Set clearcase viewstore path.
     * 
     * @param viewstore
     */
    public void setViewstore(String viewstore)
    {
        this.viewstore = viewstore;
    } //-- void setViewstore(String) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
