/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.codehaus.plexus.component.annotations.Requirement;

public abstract class AbstractReleasePomsPhase
extends AbstractReleasePhase {
    @Requirement
    private ScmRepositoryConfigurator scmRepositoryConfigurator;

    protected ScmRepository getScmRepository(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment) throws ReleaseFailureException, ReleaseExecutionException {
        try {
            return this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
        }
        catch (ScmRepositoryException exception) {
            throw new ReleaseScmRepositoryException(exception.getMessage(), exception.getValidationMessages());
        }
        catch (NoSuchScmProviderException exception) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + exception.getMessage(), (Throwable)exception);
        }
    }

    protected ScmProvider getScmProvider(ScmRepository scmRepository) throws ReleaseExecutionException {
        try {
            return this.scmRepositoryConfigurator.getRepositoryProvider(scmRepository);
        }
        catch (NoSuchScmProviderException exception) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + exception.getMessage(), (Throwable)exception);
        }
    }
}

