/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.policy.PolicyException;
import org.apache.maven.shared.release.policy.version.VersionPolicy;
import org.apache.maven.shared.release.policy.version.VersionPolicyRequest;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;

public class MapVersionsPhase
extends AbstractReleasePhase {
    private ResourceBundle resourceBundle;
    private boolean convertToSnapshot;
    private boolean convertToBranch;
    private Prompter prompter;
    private Map<String, VersionPolicy> versionPolicies;

    void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        this.resourceBundle = this.getResourceBundle(releaseEnvironment.getLocale());
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        if (releaseDescriptor.isAutoVersionSubmodules() && ArtifactUtils.isSnapshot((String)rootProject.getVersion())) {
            MavenProject project = rootProject;
            String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            String nextVersion = this.resolveNextVersion(project, projectId, releaseDescriptor, result);
            if (!this.convertToSnapshot) {
                releaseDescriptor.addReleaseVersion(projectId, nextVersion);
            } else if (releaseDescriptor.isBranchCreation() && this.convertToBranch) {
                releaseDescriptor.addReleaseVersion(projectId, nextVersion);
            } else {
                releaseDescriptor.addDevelopmentVersion(projectId, nextVersion);
            }
            for (MavenProject subProject : reactorProjects) {
                String subProjectId = ArtifactUtils.versionlessKey((String)subProject.getGroupId(), (String)subProject.getArtifactId());
                if (this.convertToSnapshot) {
                    String v = ArtifactUtils.isSnapshot((String)subProject.getVersion()) ? nextVersion : subProject.getVersion();
                    if (releaseDescriptor.isBranchCreation() && this.convertToBranch) {
                        releaseDescriptor.addReleaseVersion(subProjectId, v);
                        continue;
                    }
                    releaseDescriptor.addDevelopmentVersion(subProjectId, v);
                    continue;
                }
                releaseDescriptor.addReleaseVersion(subProjectId, nextVersion);
            }
        } else {
            for (MavenProject project : reactorProjects) {
                String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
                String nextVersion = this.resolveNextVersion(project, projectId, releaseDescriptor, result);
                if (!this.convertToSnapshot) {
                    releaseDescriptor.addReleaseVersion(projectId, nextVersion);
                    continue;
                }
                if (releaseDescriptor.isBranchCreation() && this.convertToBranch) {
                    releaseDescriptor.addReleaseVersion(projectId, nextVersion);
                    continue;
                }
                releaseDescriptor.addDevelopmentVersion(projectId, nextVersion);
            }
        }
        result.setResultCode(0);
        return result;
    }

    private String resolveNextVersion(MavenProject project, String projectId, ReleaseDescriptor releaseDescriptor, ReleaseResult result) throws ReleaseExecutionException {
        String defaultVersion;
        if (this.convertToBranch) {
            if (!releaseDescriptor.isUpdateBranchVersions() || !ArtifactUtils.isSnapshot((String)project.getVersion()) && !releaseDescriptor.isUpdateVersionsToSnapshot()) {
                return project.getVersion();
            }
            defaultVersion = this.getReleaseVersion(projectId, releaseDescriptor);
        } else if (!this.convertToSnapshot) {
            defaultVersion = this.getReleaseVersion(projectId, releaseDescriptor);
        } else if (releaseDescriptor.isBranchCreation()) {
            if (!ArtifactUtils.isSnapshot((String)project.getVersion()) || !releaseDescriptor.isUpdateWorkingCopyVersions()) {
                return project.getVersion();
            }
            defaultVersion = this.getDevelopmentVersion(projectId, releaseDescriptor);
        } else {
            if (!releaseDescriptor.isUpdateWorkingCopyVersions()) {
                return project.getVersion();
            }
            defaultVersion = this.getDevelopmentVersion(projectId, releaseDescriptor);
        }
        String suggestedVersion = null;
        String nextVersion = defaultVersion;
        String messageKey = null;
        try {
            while (nextVersion == null || ArtifactUtils.isSnapshot((String)nextVersion) != this.convertToSnapshot) {
                block24: {
                    if (suggestedVersion == null) {
                        String baseVersion = null;
                        if (this.convertToSnapshot) {
                            baseVersion = this.getReleaseVersion(projectId, releaseDescriptor);
                        }
                        if (baseVersion == null) {
                            baseVersion = project.getVersion();
                        }
                        try {
                            try {
                                suggestedVersion = this.resolveSuggestedVersion(baseVersion, releaseDescriptor.getProjectVersionPolicyId());
                            }
                            catch (VersionParseException e) {
                                if (releaseDescriptor.isInteractive()) {
                                    suggestedVersion = this.resolveSuggestedVersion("1.0", releaseDescriptor.getProjectVersionPolicyId());
                                    break block24;
                                }
                                throw new ReleaseExecutionException("Error parsing version, cannot determine next version: " + e.getMessage(), (Throwable)e);
                            }
                        }
                        catch (PolicyException | VersionParseException e) {
                            throw new ReleaseExecutionException(e.getMessage(), e);
                        }
                    }
                }
                if (releaseDescriptor.isInteractive()) {
                    if (messageKey == null) {
                        messageKey = this.getMapversionPromptKey(releaseDescriptor);
                    }
                    String message = MessageFormat.format(this.resourceBundle.getString(messageKey), project.getName(), projectId);
                    nextVersion = this.prompter.prompt(message, suggestedVersion);
                    continue;
                }
                if (defaultVersion == null) {
                    nextVersion = suggestedVersion;
                    continue;
                }
                if (this.convertToSnapshot) {
                    throw new ReleaseExecutionException(defaultVersion + " is invalid, expected a snapshot");
                }
                throw new ReleaseExecutionException(defaultVersion + " is invalid, expected a non-snapshot");
            }
        }
        catch (PrompterException e) {
            throw new ReleaseExecutionException("Error reading version from input handler: " + e.getMessage(), (Throwable)e);
        }
        return nextVersion;
    }

    private String resolveSuggestedVersion(String baseVersion, String policyId) throws PolicyException, VersionParseException {
        VersionPolicy policy = this.versionPolicies.get(policyId);
        if (policy == null) {
            throw new PolicyException("Policy '" + policyId + "' is unknown, available: " + this.versionPolicies.keySet());
        }
        VersionPolicyRequest request = new VersionPolicyRequest().setVersion(baseVersion);
        return this.convertToSnapshot ? policy.getDevelopmentVersion(request).getVersion() : policy.getReleaseVersion(request).getVersion();
    }

    private String getDevelopmentVersion(String projectId, ReleaseDescriptor releaseDescriptor) {
        String defaultVersion = releaseDescriptor.getDefaultDevelopmentVersion();
        if (StringUtils.isEmpty((String)defaultVersion)) {
            defaultVersion = releaseDescriptor.getProjectDevelopmentVersion(projectId);
        }
        return defaultVersion;
    }

    private String getReleaseVersion(String projectId, ReleaseDescriptor releaseDescriptor) {
        String nextVersion = releaseDescriptor.getDefaultReleaseVersion();
        if (StringUtils.isEmpty((String)nextVersion)) {
            nextVersion = releaseDescriptor.getProjectReleaseVersion(projectId);
        }
        return nextVersion;
    }

    private String getMapversionPromptKey(ReleaseDescriptor releaseDescriptor) {
        String messageKey = this.convertToBranch ? "mapversion.branch.prompt" : (!this.convertToSnapshot ? "mapversion.release.prompt" : (releaseDescriptor.isBranchCreation() ? "mapversion.workingcopy.prompt" : "mapversion.development.prompt"));
        return messageKey;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
        result.setResultCode(0);
        return result;
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("release-messages", locale, MapVersionsPhase.class.getClassLoader());
    }
}

