/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.text.MessageFormat;
import java.util.List;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractScmCommitPhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;

public class ScmCommitPreparationPhase
extends AbstractScmCommitPhase {
    private String rollbackMessageFormat;

    protected void runLogic(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects, ReleaseResult result, boolean simulating) throws ReleaseScmCommandException, ReleaseExecutionException, ReleaseScmRepositoryException {
        if (releaseDescriptor.isSuppressCommitBeforeTagOrBranch()) {
            if (simulating) {
                this.logInfo(result, "Full run would not commit changes, because suppressCommitBeforeTagOrBranch is set.");
            } else {
                this.logInfo(result, "Modified POMs are not committed because suppressCommitBeforeTagOrBranch is set to false.");
            }
        } else {
            String message = this.createMessage(releaseDescriptor);
            if (simulating) {
                this.simulateCheckins(releaseDescriptor, reactorProjects, result, message);
            } else {
                this.performCheckins(releaseDescriptor, releaseEnvironment, reactorProjects, message);
            }
        }
    }

    private String createRollbackMessage(ReleaseDescriptor releaseDescriptor) {
        return MessageFormat.format(releaseDescriptor.getScmCommentPrefix() + this.rollbackMessageFormat, releaseDescriptor.getScmReleaseLabel());
    }

    protected void validateConfiguration(ReleaseDescriptor releaseDescriptor) throws ReleaseFailureException {
        super.validateConfiguration(releaseDescriptor);
        if (releaseDescriptor.isSuppressCommitBeforeTagOrBranch() && releaseDescriptor.isRemoteTagging()) {
            throw new ReleaseFailureException("Cannot perform a remote tag or branch without committing the working copy first.");
        }
    }
}

