/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.doxia.site.decoration.inheritance.URIPathDescriptor;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Site;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.site.AbstractSiteMojo;
import org.apache.maven.plugins.site.wagon.repository.Repository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeployMojo
extends AbstractSiteMojo
implements Contextualizable {
    private File inputDirectory;
    private boolean chmod;
    private String chmodMode;
    private String chmodOptions;
    private boolean skipDeploy;
    private WagonManager wagonManager;
    private Settings settings;
    private PlexusContainer container;
    protected static final String DEFAULT_STAGING_DIRECTORY = "staging/";

    public void execute() throws MojoExecutionException {
        if (this.skipDeploy) {
            this.getLog().info((CharSequence)"maven.site.deploy.skip = true: Skipping site deployment");
            return;
        }
        this.deployTo(new Repository(this.getDeployRepositoryID(), AbstractDeployMojo.appendSlash(this.getDeployRepositoryURL())));
    }

    protected static String appendSlash(String url) {
        if (url.endsWith("/")) {
            return url;
        }
        return url + "/";
    }

    protected abstract String getDeployRepositoryID() throws MojoExecutionException;

    protected abstract String getDeployRepositoryURL() throws MojoExecutionException;

    private String getDeployModuleDirectory() throws MojoExecutionException {
        String relative = this.siteTool.getRelativePath(AbstractDeployMojo.getSite(this.project).getUrl(), this.getRootSite(this.project).getUrl());
        return "".equals(relative = relative.replace('\\', '/')) ? "./" : relative;
    }

    private void deployTo(org.apache.maven.wagon.repository.Repository repository) throws MojoExecutionException {
        if (!this.inputDirectory.exists()) {
            throw new MojoExecutionException("The site does not exist, please run site:site first");
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Deploying to '" + repository.getUrl() + "',\n    Using credentials from server id '" + repository.getId() + "'"));
        }
        this.deploy(this.inputDirectory, repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploy(File directory, org.apache.maven.wagon.repository.Repository repository) throws MojoExecutionException {
        Wagon wagon = AbstractDeployMojo.getWagon(repository, this.wagonManager);
        try {
            AbstractDeployMojo.configureWagon(wagon, repository.getId(), this.settings, this.container, this.getLog());
        }
        catch (WagonConfigurationException e) {
            throw new MojoExecutionException("Unable to configure Wagon: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        try {
            ProxyInfo proxyInfo = AbstractDeployMojo.getProxyInfo(repository, this.wagonManager);
            AbstractDeployMojo.push(directory, repository, this.wagonManager, wagon, proxyInfo, this.siteTool.getAvailableLocales(this.locales), this.getDeployModuleDirectory(), this.getLog());
            if (this.chmod) {
                AbstractDeployMojo.chmod(wagon, repository, this.chmodOptions, this.chmodMode);
            }
        }
        finally {
            try {
                wagon.disconnect();
            }
            catch (ConnectionException e) {
                this.getLog().error((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
            }
        }
    }

    protected File getTopLevelBuildDirectory() {
        File buildDirectory;
        MavenProject topLevelProject = AbstractDeployMojo.getTopLevelProject(this.reactorProjects);
        if (topLevelProject == null) {
            this.getLog().debug((CharSequence)"No top level project found in the reactor, using the current project.");
            buildDirectory = new File(this.project.getBuild().getDirectory());
        } else {
            this.getLog().debug((CharSequence)"Using the top level project found in the reactor.");
            buildDirectory = new File(topLevelProject.getBuild().getDirectory());
        }
        return buildDirectory;
    }

    private static Wagon getWagon(org.apache.maven.wagon.repository.Repository repository, WagonManager manager) throws MojoExecutionException {
        Wagon wagon;
        try {
            wagon = manager.getWagon(repository);
        }
        catch (UnsupportedProtocolException e) {
            throw new MojoExecutionException("Unsupported protocol: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        catch (WagonConfigurationException e) {
            throw new MojoExecutionException("Unable to configure Wagon: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        if (!wagon.supportsDirectoryCopy()) {
            throw new MojoExecutionException("Wagon protocol '" + repository.getProtocol() + "' doesn't support directory copying");
        }
        return wagon;
    }

    private static void push(File inputDirectory, org.apache.maven.wagon.repository.Repository repository, WagonManager manager, Wagon wagon, ProxyInfo proxyInfo, List<Locale> localesList, String relativeDir, Log log) throws MojoExecutionException {
        AuthenticationInfo authenticationInfo = manager.getAuthenticationInfo(repository.getId());
        log.debug((CharSequence)("authenticationInfo with id '" + repository.getId() + "': " + (authenticationInfo == null ? "-" : authenticationInfo.getUserName())));
        try {
            Debug debug = new Debug();
            wagon.addSessionListener((SessionListener)debug);
            wagon.addTransferListener((TransferListener)debug);
            if (proxyInfo != null) {
                log.debug((CharSequence)"connect with proxyInfo");
                wagon.connect(repository, authenticationInfo, proxyInfo);
            } else if (proxyInfo == null && authenticationInfo != null) {
                log.debug((CharSequence)"connect with authenticationInfo and without proxyInfo");
                wagon.connect(repository, authenticationInfo);
            } else {
                log.debug((CharSequence)"connect without authenticationInfo and without proxyInfo");
                wagon.connect(repository);
            }
            log.info((CharSequence)("Pushing " + inputDirectory));
            String defaultLocale = localesList.get(0).getLanguage();
            for (Locale locale : localesList) {
                if (locale.getLanguage().equals(defaultLocale)) {
                    log.info((CharSequence)("   >>> to " + repository.getUrl() + relativeDir));
                    wagon.putDirectory(inputDirectory, relativeDir);
                    continue;
                }
                log.info((CharSequence)("   >>> to " + repository.getUrl() + locale.getLanguage() + "/" + relativeDir));
                wagon.putDirectory(new File(inputDirectory, locale.getLanguage()), locale.getLanguage() + "/" + relativeDir);
            }
        }
        catch (ResourceDoesNotExistException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (TransferFailedException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (AuthorizationException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (ConnectionException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (AuthenticationException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
    }

    private static void chmod(Wagon wagon, org.apache.maven.wagon.repository.Repository repository, String chmodOptions, String chmodMode) throws MojoExecutionException {
        try {
            if (wagon instanceof CommandExecutor) {
                CommandExecutor exec = (CommandExecutor)wagon;
                exec.executeCommand("chmod " + chmodOptions + " " + chmodMode + " " + repository.getBasedir());
            }
        }
        catch (CommandExecutionException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
    }

    public static ProxyInfo getProxyInfo(org.apache.maven.wagon.repository.Repository repository, WagonManager wagonManager) {
        ProxyInfo proxyInfo = wagonManager.getProxy(repository.getProtocol());
        if (proxyInfo == null) {
            return null;
        }
        String host = repository.getHost();
        String nonProxyHostsAsString = proxyInfo.getNonProxyHosts();
        for (String nonProxyHost : StringUtils.split((String)nonProxyHostsAsString, (String)",;|")) {
            if (StringUtils.contains((String)nonProxyHost, (String)"*")) {
                int pos = nonProxyHost.indexOf(42);
                String nonProxyHostPrefix = nonProxyHost.substring(0, pos);
                String nonProxyHostSuffix = nonProxyHost.substring(pos + 1);
                if (StringUtils.isNotEmpty((String)nonProxyHostPrefix) && host.startsWith(nonProxyHostPrefix) && StringUtils.isEmpty((String)nonProxyHostSuffix)) {
                    return null;
                }
                if (StringUtils.isEmpty((String)nonProxyHostPrefix) && StringUtils.isNotEmpty((String)nonProxyHostSuffix) && host.endsWith(nonProxyHostSuffix)) {
                    return null;
                }
                if (!StringUtils.isNotEmpty((String)nonProxyHostPrefix) || !host.startsWith(nonProxyHostPrefix) || !StringUtils.isNotEmpty((String)nonProxyHostSuffix) || !host.endsWith(nonProxyHostSuffix)) continue;
                return null;
            }
            if (!host.equals(nonProxyHost)) continue;
            return null;
        }
        return proxyInfo;
    }

    private static void configureWagon(Wagon wagon, String repositoryId, Settings settings, PlexusContainer container, Log log) throws WagonConfigurationException {
        log.debug((CharSequence)" configureWagon ");
        for (Server server : settings.getServers()) {
            String id = server.getId();
            log.debug((CharSequence)("configureWagon server " + id));
            if (id == null || !id.equals(repositoryId) || server.getConfiguration() == null) continue;
            XmlPlexusConfiguration plexusConf = new XmlPlexusConfiguration((Xpp3Dom)server.getConfiguration());
            ComponentConfigurator componentConfigurator = null;
            try {
                componentConfigurator = (ComponentConfigurator)container.lookup(ComponentConfigurator.ROLE);
                componentConfigurator.configureComponent((Object)wagon, (PlexusConfiguration)plexusConf, container.getContainerRealm());
            }
            catch (ComponentLookupException e) {
                throw new WagonConfigurationException(repositoryId, "Unable to lookup wagon configurator. Wagon configuration cannot be applied.", (Throwable)e);
            }
            catch (ComponentConfigurationException e) {
                throw new WagonConfigurationException(repositoryId, "Unable to apply wagon configuration.", (Throwable)e);
            }
            finally {
                if (componentConfigurator == null) continue;
                try {
                    container.release((Object)componentConfigurator);
                }
                catch (ComponentLifecycleException e) {
                    log.error((CharSequence)("Problem releasing configurator - ignoring: " + e.getMessage()));
                }
            }
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    private static MavenProject getTopLevelProject(List<MavenProject> reactorProjects) {
        if (reactorProjects == null) {
            return null;
        }
        for (MavenProject reactorProject : reactorProjects) {
            if (!reactorProject.isExecutionRoot()) continue;
            return reactorProject;
        }
        return null;
    }

    protected static Site getSite(MavenProject project) throws MojoExecutionException {
        String name = project.getName() + " (" + project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion() + ")";
        DistributionManagement distributionManagement = project.getDistributionManagement();
        if (distributionManagement == null) {
            throw new MojoExecutionException("Missing distribution management in project " + name);
        }
        Site site = distributionManagement.getSite();
        if (site == null) {
            throw new MojoExecutionException("Missing site information in the distribution management of the project " + name);
        }
        if (site.getUrl() == null || site.getId() == null) {
            throw new MojoExecutionException("Missing site data: specify url and id for project " + name);
        }
        return site;
    }

    protected Site getRootSite(MavenProject project) throws MojoExecutionException {
        Site site = AbstractDeployMojo.getSite(project);
        MavenProject parent = project;
        while (parent.getParent() != null) {
            URIPathDescriptor oldSiteURI;
            parent = this.siteTool.getParentProject(parent, this.reactorProjects, this.localRepository);
            Site oldSite = site;
            try {
                site = AbstractDeployMojo.getSite(parent);
            }
            catch (MojoExecutionException e) {
                break;
            }
            URIPathDescriptor siteURI = new URIPathDescriptor(URIEncoder.encodeURI(site.getUrl()), "");
            if (siteURI.sameSite((oldSiteURI = new URIPathDescriptor(URIEncoder.encodeURI(oldSite.getUrl()), "")).getBaseURI())) continue;
            return oldSite;
        }
        return site;
    }

    private static class URIEncoder {
        private static final String mark = "-_.!~*'()";
        private static final String reserved = ";/?:@&=+$,";

        private URIEncoder() {
        }

        public static String encodeURI(String uriString) {
            char[] chars = uriString.toCharArray();
            StringBuilder uri = new StringBuilder(chars.length);
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || mark.indexOf(c) != -1 || reserved.indexOf(c) != -1) {
                    uri.append(c);
                    continue;
                }
                uri.append('%');
                uri.append(Integer.toHexString(c));
            }
            return uri.toString();
        }
    }
}

