/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XmlAppendingTransformer
implements ResourceTransformer {
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    String resource;
    Document doc;

    public boolean canTransformResource(String r) {
        return this.resource != null && this.resource.equalsIgnoreCase(r);
    }

    public void processResource(InputStream is) throws IOException {
        Document r;
        try {
            r = new SAXBuilder().build(is);
        }
        catch (JDOMException e) {
            throw new RuntimeException(e);
        }
        if (this.doc == null) {
            this.doc = r;
        } else {
            Element root = r.getRootElement();
            Iterator itr = root.getAttributes().iterator();
            while (itr.hasNext()) {
                Attribute a = (Attribute)itr.next();
                itr.remove();
                Element mergedEl = this.doc.getRootElement();
                Attribute mergedAtt = mergedEl.getAttribute(a.getName(), a.getNamespace());
                if (mergedAtt != null) continue;
                mergedEl.setAttribute(a);
            }
            itr = root.getChildren().iterator();
            while (itr.hasNext()) {
                Content n = (Content)itr.next();
                itr.remove();
                this.doc.getRootElement().addContent(n);
            }
        }
    }

    public boolean hasTransformedResource() {
        return this.doc != null;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        jos.putNextEntry(new JarEntry(this.resource));
        new XMLOutputter(Format.getPrettyFormat()).output(this.doc, (OutputStream)jos);
        this.doc = null;
    }
}

