/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.release.AbstractReleaseMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.shared.release.config.ReleaseDescriptorBuilder;

public abstract class AbstractScmReleaseMojo
extends AbstractReleaseMojo {
    @Parameter(property="username")
    private String username;
    @Parameter(property="password")
    private String password;
    @Parameter(alias="releaseLabel", property="tag")
    private String tag;
    @Parameter(defaultValue="@{project.artifactId}-@{project.version}", property="tagNameFormat")
    private String tagNameFormat;
    @Parameter(property="tagBase")
    private String tagBase;
    @Parameter(defaultValue="[maven-release-plugin] ", property="scmCommentPrefix")
    private String scmCommentPrefix;
    @Parameter(defaultValue="true", property="pushChanges")
    private boolean pushChanges = true;
    @Parameter(property="workItem")
    private String workItem;
    @Parameter
    private Map<String, String> providerImplementations;
    @Component
    private ScmManager scmManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.providerImplementations != null) {
            for (Map.Entry<String, String> providerEntry : this.providerImplementations.entrySet()) {
                this.getLog().info((CharSequence)("Change the default '" + providerEntry.getKey() + "' provider implementation to '" + providerEntry.getValue() + "'."));
                this.scmManager.setScmProviderImplementation(providerEntry.getKey(), providerEntry.getValue());
            }
        }
    }

    @Override
    protected ReleaseDescriptorBuilder createReleaseDescriptor() {
        ReleaseDescriptorBuilder descriptor = super.createReleaseDescriptor();
        descriptor.setScmPassword(this.password);
        descriptor.setScmReleaseLabel(this.tag);
        descriptor.setScmTagNameFormat(this.tagNameFormat);
        descriptor.setScmTagBase(this.tagBase);
        descriptor.setScmUsername(this.username);
        descriptor.setScmCommentPrefix(this.scmCommentPrefix);
        descriptor.setPushChanges(this.pushChanges);
        descriptor.setWorkItem(this.workItem);
        if (this.project.getScm() != null) {
            if (this.project.getScm().getDeveloperConnection() != null) {
                descriptor.setScmSourceUrl(this.project.getScm().getDeveloperConnection());
            } else if (this.project.getScm().getConnection() != null) {
                descriptor.setScmSourceUrl(this.project.getScm().getConnection());
            }
        }
        descriptor.setScmId(this.project.getProperties().getProperty("project.scm.id"));
        for (MavenProject reactorProject : this.session.getProjects()) {
            if (reactorProject.getScm() == null) continue;
            String projectId = ArtifactUtils.versionlessKey((String)reactorProject.getGroupId(), (String)reactorProject.getArtifactId());
            descriptor.addOriginalScmInfo(projectId, this.buildScm(reactorProject));
        }
        return descriptor;
    }

    protected Scm buildScm(MavenProject project) {
        Scm scm;
        if (project.getOriginalModel().getScm() == null) {
            scm = null;
        } else {
            scm = new Scm();
            scm.setConnection(project.getOriginalModel().getScm().getConnection());
            scm.setDeveloperConnection(project.getOriginalModel().getScm().getDeveloperConnection());
            scm.setTag(project.getOriginalModel().getScm().getTag());
            scm.setUrl(project.getOriginalModel().getScm().getUrl());
        }
        return scm;
    }
}

