/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo.dependencies;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.JarData;
import org.apache.maven.shared.jar.classes.JarClassesAnalysis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dependencies {
    private final MavenProject project;
    private final DependencyNode dependencyTreeNode;
    private final JarClassesAnalysis classesAnalyzer;
    private List<Artifact> projectDependencies;
    private List<Artifact> projectTransitiveDependencies;
    private List<Artifact> allDependencies;
    private Map<String, List<Artifact>> dependenciesByScope;
    private Map<String, List<Artifact>> transitiveDependenciesByScope;
    private Map<String, JarData> dependencyDetails;

    public Dependencies(MavenProject project, DependencyNode dependencyTreeNode, JarClassesAnalysis classesAnalyzer) {
        this.project = project;
        this.dependencyTreeNode = dependencyTreeNode;
        this.classesAnalyzer = classesAnalyzer;
        this.mapArtifactFiles(this.dependencyTreeNode);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean hasDependencies() {
        return this.getProjectDependencies() != null && !this.getProjectDependencies().isEmpty();
    }

    public List<Artifact> getProjectDependencies() {
        if (this.projectDependencies != null) {
            return this.projectDependencies;
        }
        this.projectDependencies = new ArrayList<Artifact>();
        for (DependencyNode dependencyNode : this.dependencyTreeNode.getChildren()) {
            this.projectDependencies.add(dependencyNode.getArtifact());
        }
        return this.projectDependencies;
    }

    public List<Artifact> getTransitiveDependencies() {
        if (this.projectTransitiveDependencies != null) {
            return this.projectTransitiveDependencies;
        }
        this.projectTransitiveDependencies = new ArrayList<Artifact>(this.getAllDependencies());
        this.projectTransitiveDependencies.removeAll(this.getProjectDependencies());
        return this.projectTransitiveDependencies;
    }

    public List<Artifact> getAllDependencies() {
        if (this.allDependencies != null) {
            return this.allDependencies;
        }
        this.allDependencies = new ArrayList<Artifact>();
        for (DependencyNode dependencyNode : this.dependencyTreeNode.getChildren()) {
            if (dependencyNode.getState() != 0 || dependencyNode.getArtifact().getGroupId().equals(this.project.getGroupId()) && dependencyNode.getArtifact().getArtifactId().equals(this.project.getArtifactId()) && dependencyNode.getArtifact().getVersion().equals(this.project.getVersion())) continue;
            if (!this.allDependencies.contains(dependencyNode.getArtifact())) {
                this.allDependencies.add(dependencyNode.getArtifact());
            }
            this.getAllDependencies(dependencyNode);
        }
        return this.allDependencies;
    }

    public Map<String, List<Artifact>> getDependenciesByScope(boolean isTransitively) {
        if (isTransitively) {
            if (this.transitiveDependenciesByScope != null) {
                return this.transitiveDependenciesByScope;
            }
            this.transitiveDependenciesByScope = new HashMap<String, List<Artifact>>();
            for (Artifact artifact : this.getTransitiveDependencies()) {
                List<Artifact> multiValue = this.transitiveDependenciesByScope.get(artifact.getScope());
                if (multiValue == null) {
                    multiValue = new ArrayList<Artifact>();
                }
                if (!multiValue.contains(artifact)) {
                    multiValue.add(artifact);
                }
                this.transitiveDependenciesByScope.put(artifact.getScope(), multiValue);
            }
            return this.transitiveDependenciesByScope;
        }
        if (this.dependenciesByScope != null) {
            return this.dependenciesByScope;
        }
        this.dependenciesByScope = new HashMap<String, List<Artifact>>();
        for (Artifact artifact : this.getProjectDependencies()) {
            List<Artifact> multiValue = this.dependenciesByScope.get(artifact.getScope());
            if (multiValue == null) {
                multiValue = new ArrayList<Artifact>();
            }
            if (!multiValue.contains(artifact)) {
                multiValue.add(artifact);
            }
            this.dependenciesByScope.put(artifact.getScope(), multiValue);
        }
        return this.dependenciesByScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarData getJarDependencyDetails(Artifact artifact) throws IOException {
        if (this.dependencyDetails == null) {
            this.dependencyDetails = new HashMap<String, JarData>();
        }
        JarData old = this.dependencyDetails.get(artifact.getId());
        if (this.dependencyDetails.get(artifact.getId()) != null) {
            return old;
        }
        JarAnalyzer jarAnalyzer = new JarAnalyzer(artifact.getFile());
        try {
            this.classesAnalyzer.analyze(jarAnalyzer);
        }
        finally {
            jarAnalyzer.closeQuietly();
        }
        this.dependencyDetails.put(artifact.getId(), jarAnalyzer.getJarData());
        return jarAnalyzer.getJarData();
    }

    private void mapArtifactFiles(DependencyNode node) {
        List childs = node.getChildren();
        if (childs == null || childs.isEmpty()) {
            return;
        }
        for (DependencyNode anode : childs) {
            String key = ArtifactUtils.versionlessKey((Artifact)anode.getArtifact());
            Artifact projartifact = (Artifact)this.project.getArtifactMap().get(key);
            if (projartifact != null) {
                anode.getArtifact().setFile(projartifact.getFile());
            }
            this.mapArtifactFiles(anode);
        }
    }

    private void getAllDependencies(DependencyNode dependencyNode) {
        if (dependencyNode == null || dependencyNode.getChildren() == null) {
            if (!this.allDependencies.contains(dependencyNode.getArtifact())) {
                this.allDependencies.add(dependencyNode.getArtifact());
            }
            return;
        }
        for (DependencyNode subdependencyNode : dependencyNode.getChildren()) {
            if (subdependencyNode.getState() != 0 || subdependencyNode.getArtifact().getGroupId().equals(this.project.getGroupId()) && subdependencyNode.getArtifact().getArtifactId().equals(this.project.getArtifactId()) && subdependencyNode.getArtifact().getVersion().equals(this.project.getVersion())) continue;
            if (!this.allDependencies.contains(subdependencyNode.getArtifact())) {
                this.allDependencies.add(subdependencyNode.getArtifact());
            }
            this.getAllDependencies(subdependencyNode);
        }
    }
}

