/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;

public class ProjectIndexPageReport
extends AbstractProjectInfoReport {
    public String getName(Locale locale) {
        return this.getI18nString(locale, "title");
    }

    public String getDescription(Locale locale) {
        if (this.project.getDescription() == null) {
            return this.getI18nString(locale, "nodescription");
        }
        String desc = this.project.getDescription();
        return desc;
    }

    public void executeReport(Locale locale) {
        ProjectIndexRenderer r = new ProjectIndexRenderer(this.getName(locale), this.project.getName(), this.getDescription(locale), this.getSink());
        r.render();
    }

    public String getOutputName() {
        return "index";
    }

    protected String getI18Nsection() {
        return "index";
    }

    private static class ProjectIndexRenderer
    extends AbstractMavenReportRenderer {
        private final String title;
        private final String description;
        private final String name;

        ProjectIndexRenderer(String title, String name, String description, Sink sink) {
            super(sink);
            this.title = title;
            this.description = description;
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void renderBody() {
            this.startSection(this.title.trim() + " " + this.name);
            this.paragraph(this.description);
            this.endSection();
        }
    }
}

