/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class MailingListsReport
extends AbstractProjectInfoReport {
    protected String introduction;

    public void executeReport(Locale locale) {
        MailingListsRenderer r = new MailingListsRenderer(this.getSink(), this.getProject().getModel(), this.i18n, locale, this.introduction);
        r.render();
    }

    public String getOutputName() {
        return "mail-lists";
    }

    protected String getI18Nsection() {
        return "mailing-lists";
    }

    protected static class MailingListsRenderer
    extends AbstractProjectInfoRenderer {
        private Model model;
        private static final String[] EMPTY_STRING_ARRAY = new String[0];
        private String introduction;

        MailingListsRenderer(Sink sink, Model model, I18N i18n, Locale locale, String introduction) {
            super(sink, i18n, locale);
            this.model = model;
            this.introduction = introduction;
        }

        protected String getI18Nsection() {
            return "mailing-lists";
        }

        public void renderBody() {
            List mailingLists = this.model.getMailingLists();
            if (mailingLists == null || mailingLists.isEmpty()) {
                this.startSection(this.getTitle());
                this.paragraph(this.getI18nString("nolist"));
                this.endSection();
                return;
            }
            this.startSection(this.getTitle());
            if (StringUtils.isNotBlank((String)this.introduction)) {
                this.paragraph(this.introduction);
            } else {
                this.paragraph(this.getI18nString("intro"));
            }
            this.startTable();
            boolean otherArchives = false;
            Iterator i = mailingLists.iterator();
            while (i.hasNext()) {
                MailingList m = (MailingList)i.next();
                if (m.getOtherArchives() == null || m.getOtherArchives().isEmpty()) continue;
                otherArchives = true;
            }
            String name = this.getI18nString("column.name");
            String subscribe = this.getI18nString("column.subscribe");
            String unsubscribe = this.getI18nString("column.unsubscribe");
            String post = this.getI18nString("column.post");
            String archive = this.getI18nString("column.archive");
            String archivesOther = this.getI18nString("column.otherArchives");
            if (otherArchives) {
                this.tableHeader(new String[]{name, subscribe, unsubscribe, post, archive, archivesOther});
            } else {
                this.tableHeader(new String[]{name, subscribe, unsubscribe, post, archive});
            }
            Iterator i2 = this.model.getMailingLists().iterator();
            while (i2.hasNext()) {
                MailingList mailingList = (MailingList)i2.next();
                ArrayList<String> textRow = new ArrayList<String>();
                textRow.add(mailingList.getName());
                textRow.add(MailingListsRenderer.createLinkPatternedText((String)subscribe, (String)mailingList.getSubscribe()));
                textRow.add(MailingListsRenderer.createLinkPatternedText((String)unsubscribe, (String)mailingList.getUnsubscribe()));
                if (mailingList.getPost() != null && mailingList.getPost().length() > 0) {
                    textRow.add(MailingListsRenderer.createLinkPatternedText((String)post, (String)mailingList.getPost()));
                } else {
                    textRow.add("-");
                }
                if (mailingList.getArchive() != null && mailingList.getArchive().length() > 0) {
                    textRow.add(MailingListsRenderer.createLinkPatternedText((String)MailingListsRenderer.getArchiveServer(mailingList.getArchive()), (String)mailingList.getArchive()));
                } else {
                    textRow.add("-");
                }
                if (mailingList.getOtherArchives() != null && !mailingList.getOtherArchives().isEmpty()) {
                    Iterator it = mailingList.getOtherArchives().iterator();
                    String otherArchive = it.next().toString();
                    textRow.add(MailingListsRenderer.createLinkPatternedText((String)MailingListsRenderer.getArchiveServer(otherArchive), (String)otherArchive));
                    this.tableRow(textRow.toArray(EMPTY_STRING_ARRAY));
                    while (it.hasNext()) {
                        otherArchive = (String)it.next();
                        textRow = new ArrayList();
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(MailingListsRenderer.createLinkPatternedText((String)MailingListsRenderer.getArchiveServer(otherArchive), (String)otherArchive));
                        this.tableRow(textRow.toArray(EMPTY_STRING_ARRAY));
                    }
                    continue;
                }
                if (otherArchives) {
                    textRow.add(null);
                }
                this.tableRow(textRow.toArray(EMPTY_STRING_ARRAY));
            }
            this.endTable();
            this.endSection();
        }

        private static String getArchiveServer(String uri) {
            if (StringUtils.isEmpty((String)uri)) {
                return "???UNKNOWN???";
            }
            int at = uri.indexOf("//");
            int fromIndex = at >= 0 ? (uri.lastIndexOf("/", at - 1) >= 0 ? 0 : at + 2) : 0;
            int from = uri.indexOf("/", fromIndex);
            if (from == -1) {
                return uri.substring(at + 2);
            }
            return uri.substring(at + 2, from);
        }
    }
}

