/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Model;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class IssueTrackingReport
extends AbstractProjectInfoReport {
    public void executeReport(Locale locale) {
        IssueTrackingRenderer r = new IssueTrackingRenderer(this.getSink(), this.getProject().getModel(), this.i18n, locale);
        r.render();
    }

    public String getOutputName() {
        return "issue-tracking";
    }

    protected String getI18Nsection() {
        return "issuetracking";
    }

    private static class IssueTrackingRenderer
    extends AbstractProjectInfoRenderer {
        private Model model;

        IssueTrackingRenderer(Sink sink, Model model, I18N i18n, Locale locale) {
            super(sink, i18n, locale);
            this.model = model;
        }

        protected String getI18Nsection() {
            return "issuetracking";
        }

        public void renderBody() {
            IssueManagement issueManagement = this.model.getIssueManagement();
            if (issueManagement == null) {
                this.startSection(this.getTitle());
                this.paragraph(this.getI18nString("noissueManagement"));
                this.endSection();
                return;
            }
            String system = issueManagement.getSystem();
            String url = issueManagement.getUrl();
            this.startSection(this.getI18nString("overview.title"));
            if (this.isIssueManagementSystem(system, "jira")) {
                this.sink.paragraph();
                this.linkPatternedText(this.getI18nString("jira.intro"));
                this.sink.paragraph_();
            } else if (this.isIssueManagementSystem(system, "bugzilla")) {
                this.sink.paragraph();
                this.linkPatternedText(this.getI18nString("bugzilla.intro"));
                this.sink.paragraph_();
            } else if (this.isIssueManagementSystem(system, "scarab")) {
                this.sink.paragraph();
                this.linkPatternedText(this.getI18nString("scarab.intro"));
                this.sink.paragraph_();
            } else if (system == null || "".equals(system.trim())) {
                this.paragraph(this.getI18nString("general.intro"));
            } else {
                this.paragraph(this.getI18nString("custom.intro").replaceFirst("%issueManagementSystem%", system));
            }
            this.endSection();
            this.startSection(this.getTitle());
            this.paragraph(this.getI18nString("intro"));
            this.verbatimLink(url, url);
            this.endSection();
        }

        private boolean isIssueManagementSystem(String system, String im) {
            if (StringUtils.isEmpty((String)system)) {
                return false;
            }
            if (StringUtils.isEmpty((String)im)) {
                return false;
            }
            return system.toLowerCase(Locale.ENGLISH).startsWith(im.toLowerCase(Locale.ENGLISH));
        }
    }
}

