/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.render.RenderingContext;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractProjectInfoReport
extends AbstractMavenReport {
    protected SiteTool siteTool;
    protected Renderer siteRenderer;
    protected ArtifactResolver resolver;
    protected ArtifactFactory factory;
    protected I18N i18n;
    protected File outputDirectory;
    protected MavenProject project;
    protected ArtifactRepository localRepository;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            return;
        }
        OutputStreamWriter writer = null;
        try {
            String filename = this.getOutputName() + ".html";
            DecorationModel model = new DecorationModel();
            model.setBody(new Body());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("outputEncoding", "UTF-8");
            attributes.put("project", (String)this.project);
            Locale locale = Locale.getDefault();
            Artifact defaultSkin = this.siteTool.getDefaultSkinArtifact(this.localRepository, this.project.getRemoteArtifactRepositories());
            SiteRenderingContext siteContext = this.siteRenderer.createContextForSkin(defaultSkin.getFile(), attributes, model, this.getName(locale), locale);
            RenderingContext context = new RenderingContext(this.outputDirectory, filename);
            SiteRendererSink sink = new SiteRendererSink(context);
            this.generate((Sink)sink, null, locale);
            this.outputDirectory.mkdirs();
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.outputDirectory, filename)), "UTF-8");
            this.siteRenderer.generateDocument((Writer)writer, sink, siteContext);
            this.siteRenderer.copyResources(siteContext, new File(this.project.getBasedir(), "src/site/resources"), this.outputDirectory);
        }
        catch (RendererException e) {
            try {
                throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
                catch (IOException e2) {
                    throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)e2);
                }
                catch (SiteToolException e3) {
                    throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e3));
                }
                catch (MavenReportException e4) {
                    throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e4));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    public String getCategoryName() {
        return "Project Info";
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getI18nString(Locale locale, String key) {
        return this.i18n.getString("project-info-report", locale, "report." + this.getI18Nsection() + '.' + key);
    }

    protected abstract String getI18Nsection();

    public String getName(Locale locale) {
        return this.getI18nString(locale, "name");
    }

    public String getDescription(Locale locale) {
        return this.getI18nString(locale, "description");
    }
}

