package org.apache.maven.report.projectinfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-project-info-reports-plugin.<br/> Call <pre>  mvn project-info-reports:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sat May 15 23:28:55 CEST 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-project-info-reports-plugin:2.2", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Project Info Reports Plugin", 0 );
        append( sb, "The Maven Project Info Reports Plugin is a plugin that generates standard reports for the specified project.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 15 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "cim".equals( goal ) )
        {
            append( sb, "project-info-reports:cim", 0 );
            append( sb, "Generates the Project Continuous Integration System report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "dependencies".equals( goal ) )
        {
            append( sb, "project-info-reports:dependencies", 0 );
            append( sb, "Generates the Project Dependencies report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "dependencyDetailsEnabled (Default: true)", 2 );
                append( sb, "Display file details for each dependency, such as: file size, number of classes, number of packages etc.", 3 );
                append( sb, "", 0 );

                append( sb, "dependencyLocationsEnabled (Default: true)", 2 );
                append( sb, "Display the repository locations of the dependencies. If Maven is configured to be offline, this parameter will be ignored.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "dependency-convergence".equals( goal ) )
        {
            append( sb, "project-info-reports:dependency-convergence", 0 );
            append( sb, "Generates the Dependency Convergence report for reactor builds.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "dependency-management".equals( goal ) )
        {
            append( sb, "project-info-reports:dependency-management", 0 );
            append( sb, "Generates the Project Dependency Management report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "remoteRepositories", 2 );
                append( sb, "Remote repositories used for the project.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "project-info-reports:help", 0 );
            append( sb, "Display help information on maven-project-info-reports-plugin.\nCall\n\u00a0\u00a0mvn\u00a0project-info-reports:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "index".equals( goal ) )
        {
            append( sb, "project-info-reports:index", 0 );
            append( sb, "Generates the project index page.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "issue-tracking".equals( goal ) )
        {
            append( sb, "project-info-reports:issue-tracking", 0 );
            append( sb, "Generates the Project Issue Tracking report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "license".equals( goal ) )
        {
            append( sb, "project-info-reports:license", 0 );
            append( sb, "Generates the Project License report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "offline", 2 );
                append( sb, "Whether the system is currently offline.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "mailing-list".equals( goal ) )
        {
            append( sb, "project-info-reports:mailing-list", 0 );
            append( sb, "Generates the Mailing List report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "introduction", 2 );
                append( sb, "This can override the header text of the mailing list(s) report", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "modules".equals( goal ) )
        {
            append( sb, "project-info-reports:modules", 0 );
            append( sb, "Generates the Project Modules report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "plugin-management".equals( goal ) )
        {
            append( sb, "project-info-reports:plugin-management", 0 );
            append( sb, "Generates the Project Plugin Management report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "plugins".equals( goal ) )
        {
            append( sb, "project-info-reports:plugins", 0 );
            append( sb, "Generates the Project Plugins report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "project-team".equals( goal ) )
        {
            append( sb, "project-info-reports:project-team", 0 );
            append( sb, "Generates the Project Team report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "scm".equals( goal ) )
        {
            append( sb, "project-info-reports:scm", 0 );
            append( sb, "Generates the Project Source Code Management (SCM) report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "anonymousConnection (Default: ${project.scm.connection})", 2 );
                append( sb, "The SCM anonymous connection url respecting the SCM URL Format.", 3 );
                append( sb, "", 0 );

                append( sb, "checkoutDirectoryName (Default: ${project.artifactId})", 2 );
                append( sb, "The directory name to checkout right after the SCM URL.", 3 );
                append( sb, "", 0 );

                append( sb, "developerConnection (Default: ${project.scm.developerConnection})", 2 );
                append( sb, "The SCM developer connection url respecting the SCM URL Format.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "webAccessUrl (Default: ${project.scm.url})", 2 );
                append( sb, "The SCM web access url.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "summary".equals( goal ) )
        {
            append( sb, "project-info-reports:summary", 0 );
            append( sb, "Generates the project information reports summary.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
