/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSetReferenceId;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.benchmark.Benchmarker;
import net.sourceforge.pmd.benchmark.TextReport;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.renderers.CSVRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.renderers.XMLRenderer;
import net.sourceforge.pmd.util.ResourceLoader;
import net.sourceforge.pmd.util.datasource.DataSource;
import net.sourceforge.pmd.util.datasource.FileDataSource;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.pmd.AbstractPmdReport;
import org.apache.maven.plugins.pmd.ExcludeViolationsFromFile;
import org.apache.maven.plugins.pmd.PmdCollectingRenderer;
import org.apache.maven.plugins.pmd.PmdReportGenerator;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.artifact.filter.resolve.AndFilter;
import org.apache.maven.shared.artifact.filter.resolve.ExclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="pmd", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class PmdReport
extends AbstractPmdReport {
    @Parameter(property="targetJdk", defaultValue="${maven.compiler.source}")
    private String targetJdk;
    @Parameter(defaultValue="java")
    private String language;
    @Parameter(property="minimumPriority", defaultValue="5")
    private int minimumPriority = 5;
    @Parameter(property="pmd.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private String[] rulesets = new String[]{"/rulesets/java/maven-pmd-plugin-default.xml"};
    @Parameter(property="pmd.typeResolution", defaultValue="true")
    private boolean typeResolution;
    @Parameter(property="pmd.benchmark", defaultValue="false")
    private boolean benchmark;
    @Parameter(property="pmd.benchmarkOutputFilename", defaultValue="${project.build.directory}/pmd-benchmark.txt")
    private String benchmarkOutputFilename;
    @Parameter(property="pmd.suppressMarker")
    private String suppressMarker;
    @Component
    private ResourceManager locator;
    private PmdCollectingRenderer renderer;
    private final ExcludeViolationsFromFile excludeFromFile = new ExcludeViolationsFromFile();
    @Parameter(property="pmd.skipPmdError", defaultValue="true")
    private boolean skipPmdError;
    @Parameter(property="pmd.analysisCache", defaultValue="false")
    private boolean analysisCache;
    @Parameter(property="pmd.analysisCacheLocation", defaultValue="${project.build.directory}/pmd/pmd.cache")
    private String analysisCacheLocation;
    @Parameter(property="pmd.renderProcessingErrors", defaultValue="true")
    private boolean renderProcessingErrors = true;
    @Parameter(property="pmd.renderRuleViolationPriority", defaultValue="true")
    private boolean renderRuleViolationPriority = true;
    @Parameter(property="pmd.renderViolationsByPriority", defaultValue="true")
    private boolean renderViolationsByPriority = true;
    @Parameter(property="pmd.rulesetsTargetDirectory", defaultValue="${project.build.directory}/pmd/rulesets")
    private File rulesetsTargetDirectory;
    @Component
    private DependencyResolver dependencyResolver;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;

    public String getName(Locale locale) {
        return PmdReport.getBundle(locale).getString("report.pmd.name");
    }

    public String getDescription(Locale locale) {
        return PmdReport.getBundle(locale).getString("report.pmd.description");
    }

    public void setRulesets(String[] rulesets) {
        this.rulesets = Arrays.copyOf(rulesets, rulesets.length);
    }

    public void executeReport(Locale locale) throws MavenReportException {
        try {
            this.execute(locale);
        }
        finally {
            if (this.getSink() != null) {
                this.getSink().close();
            }
        }
    }

    private void execute(Locale locale) throws MavenReportException {
        if (!this.skip && this.canGenerateReport()) {
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                this.generateMavenSiteReport(locale);
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
    }

    @Override
    public boolean canGenerateReport() {
        if (this.skip) {
            return false;
        }
        boolean result = super.canGenerateReport();
        if (result) {
            try {
                this.executePmdWithClassloader();
                if (this.skipEmptyReport && (result = this.renderer.hasViolations())) {
                    this.getLog().debug((CharSequence)"Skipping report since skipEmptyReport is true andthere are no PMD violations.");
                }
            }
            catch (MavenReportException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private void executePmdWithClassloader() throws MavenReportException {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.executePmd();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    private void executePmd() throws MavenReportException {
        this.setupPmdLogging();
        if (this.renderer != null) {
            this.getLog().debug((CharSequence)"PMD has already been run - skipping redundant execution.");
            return;
        }
        try {
            this.excludeFromFile.loadExcludeFromFailuresData(this.excludeFromFailureFile);
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Unable to load exclusions", (Exception)((Object)e));
        }
        this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
        this.locator.addSearchPath("url", "");
        this.locator.setOutputDirectory(this.rulesetsTargetDirectory);
        this.renderer = new PmdCollectingRenderer();
        PMDConfiguration pmdConfiguration = this.getPMDConfiguration();
        Object[] sets = new String[this.rulesets.length];
        try {
            for (int idx = 0; idx < this.rulesets.length; ++idx) {
                String set = this.rulesets[idx];
                this.getLog().debug((CharSequence)("Preparing ruleset: " + set));
                RuleSetReferenceId id = new RuleSetReferenceId(set);
                File ruleset = this.locator.getResourceAsFile(id.getRuleSetFileName(), this.getLocationTemp(set));
                if (null == ruleset) {
                    throw new MavenReportException("Could not resolve " + set);
                }
                sets[idx] = ruleset.getAbsolutePath();
            }
        }
        catch (ResourceNotFoundException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        catch (FileResourceCreationException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        pmdConfiguration.setRuleSets(StringUtils.join((Object[])sets, (String)","));
        try {
            if (this.filesToProcess == null) {
                this.filesToProcess = this.getFilesToProcess();
            }
            if (this.filesToProcess.isEmpty() && !"java".equals(this.language)) {
                this.getLog().warn((CharSequence)"No files found to process. Did you add your additional source folders like javascript? (see also build-helper-maven-plugin)");
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Can't get file list", (Exception)e);
        }
        String encoding = this.getSourceEncoding();
        if (StringUtils.isEmpty((String)encoding)) {
            encoding = ReaderFactory.FILE_ENCODING;
            if (!this.filesToProcess.isEmpty()) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            }
        }
        pmdConfiguration.setSourceEncoding(encoding);
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>(this.filesToProcess.size());
        for (File f : this.filesToProcess.keySet()) {
            dataSources.add((DataSource)new FileDataSource(f));
        }
        if (sets.length > 0) {
            this.processFilesWithPMD(pmdConfiguration, dataSources);
        } else {
            this.getLog().debug((CharSequence)"Skipping PMD execution as no rulesets are defined.");
        }
        if (this.renderer.hasErrors()) {
            if (!this.skipPmdError) {
                this.getLog().error((CharSequence)"PMD processing errors:");
                this.getLog().error((CharSequence)this.renderer.getErrorsAsString(this.getLog().isDebugEnabled()));
                throw new MavenReportException("Found " + this.renderer.getErrors().size() + " PMD processing errors");
            }
            this.getLog().warn((CharSequence)("There are " + this.renderer.getErrors().size() + " PMD processing errors:"));
            this.getLog().warn((CharSequence)this.renderer.getErrorsAsString(this.getLog().isDebugEnabled()));
        }
        this.removeExcludedViolations(this.renderer.getViolations());
        if (this.renderer != null) {
            Report report = this.renderer.asReport();
            this.writeXmlReport(report);
            if (!this.isHtml() && !this.isXml()) {
                this.writeFormattedReport(report);
            }
        }
        if (this.benchmark) {
            try (PrintStream benchmarkFileStream = new PrintStream(this.benchmarkOutputFilename);){
                new TextReport().generate(Benchmarker.values(), benchmarkFileStream);
            }
            catch (FileNotFoundException fnfe) {
                this.getLog().error((CharSequence)("Unable to generate benchmark file: " + this.benchmarkOutputFilename), (Throwable)fnfe);
            }
        }
    }

    private void removeExcludedViolations(List<RuleViolation> violations) {
        this.getLog().debug((CharSequence)("Removing excluded violations. Using " + this.excludeFromFile.countExclusions() + " configured exclusions."));
        int violationsBefore = violations.size();
        Iterator<RuleViolation> iterator = violations.iterator();
        while (iterator.hasNext()) {
            RuleViolation rv = iterator.next();
            if (!this.excludeFromFile.isExcludedFromFailure(rv)) continue;
            iterator.remove();
        }
        int numberOfExcludedViolations = violationsBefore - violations.size();
        this.getLog().debug((CharSequence)("Excluded " + numberOfExcludedViolations + " violations."));
    }

    private void processFilesWithPMD(PMDConfiguration pmdConfiguration, List<DataSource> dataSources) throws MavenReportException {
        RuleSetFactory ruleSetFactory = new RuleSetFactory(new ResourceLoader(), RulePriority.valueOf((int)this.minimumPriority), true, true);
        try {
            ruleSetFactory.createRuleSets(pmdConfiguration.getRuleSets());
        }
        catch (RuleSetNotFoundException e1) {
            throw new MavenReportException("The ruleset could not be loaded", (Exception)((Object)e1));
        }
        try {
            this.getLog().debug((CharSequence)"Executing PMD...");
            RuleContext ruleContext = new RuleContext();
            PMD.processFiles((PMDConfiguration)pmdConfiguration, (RuleSetFactory)ruleSetFactory, dataSources, (RuleContext)ruleContext, Arrays.asList(new Renderer[]{this.renderer}));
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("PMD finished. Found " + this.renderer.getViolations().size() + " violations."));
            }
        }
        catch (Exception e) {
            String message = "Failure executing PMD: " + e.getLocalizedMessage();
            if (!this.skipPmdError) {
                throw new MavenReportException(message, e);
            }
            this.getLog().warn((CharSequence)message, (Throwable)e);
        }
    }

    private void generateMavenSiteReport(Locale locale) throws MavenReportException {
        Sink sink = this.getSink();
        PmdReportGenerator doxiaRenderer = new PmdReportGenerator(this.getLog(), sink, PmdReport.getBundle(locale), this.aggregate);
        doxiaRenderer.setRenderRuleViolationPriority(this.renderRuleViolationPriority);
        doxiaRenderer.setRenderViolationsByPriority(this.renderViolationsByPriority);
        doxiaRenderer.setFiles(this.filesToProcess);
        doxiaRenderer.setViolations(this.renderer.getViolations());
        if (this.renderProcessingErrors) {
            doxiaRenderer.setProcessingErrors(this.renderer.getErrors());
        }
        try {
            doxiaRenderer.beginDocument();
            doxiaRenderer.render();
            doxiaRenderer.endDocument();
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failure creating the report: " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    protected String getLocationTemp(String name) {
        String loc = name;
        if (loc.indexOf(47) != -1) {
            loc = loc.substring(loc.lastIndexOf(47) + 1);
        }
        if (loc.indexOf(92) != -1) {
            loc = loc.substring(loc.lastIndexOf(92) + 1);
        }
        if (!(loc = loc.replaceAll("[\\?\\:\\&\\=\\%]", "_")).endsWith(".xml")) {
            loc = loc + ".xml";
        }
        this.getLog().debug((CharSequence)("Before: " + name + " After: " + loc));
        return loc;
    }

    private File writeReport(Report report, Renderer r, String extension) throws MavenReportException {
        if (r == null) {
            return null;
        }
        File targetFile = new File(this.targetDirectory, "pmd." + extension);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), this.getOutputEncoding());){
            this.targetDirectory.mkdirs();
            r.setWriter((Writer)writer);
            r.start();
            r.renderFileReport(report);
            r.end();
            r.flush();
        }
        catch (IOException ioe) {
            throw new MavenReportException(ioe.getMessage(), (Exception)ioe);
        }
        return targetFile;
    }

    private void writeFormattedReport(Report report) throws MavenReportException {
        Renderer r = this.createRenderer();
        this.writeReport(report, r, this.format);
    }

    private void writeXmlReport(Report report) throws MavenReportException {
        File targetFile = this.writeReport(report, (Renderer)new XMLRenderer(this.getOutputEncoding()), "xml");
        if (this.includeXmlInSite) {
            File siteDir = this.getReportOutputDirectory();
            siteDir.mkdirs();
            try {
                FileUtils.copyFile((File)targetFile, (File)new File(siteDir, "pmd.xml"));
            }
            catch (IOException e) {
                throw new MavenReportException(e.getMessage(), (Exception)e);
            }
        }
    }

    public PMDConfiguration getPMDConfiguration() throws MavenReportException {
        PMDConfiguration configuration = new PMDConfiguration();
        LanguageVersion languageVersion = null;
        if (("java".equals(this.language) || null == this.language) && null != this.targetJdk) {
            languageVersion = LanguageRegistry.findLanguageVersionByTerseName((String)("java " + this.targetJdk));
            if (languageVersion == null) {
                throw new MavenReportException("Unsupported targetJdk value '" + this.targetJdk + "'.");
            }
        } else if ("javascript".equals(this.language) || "ecmascript".equals(this.language)) {
            languageVersion = LanguageRegistry.findLanguageVersionByTerseName((String)"ecmascript");
        } else if ("jsp".equals(this.language)) {
            languageVersion = LanguageRegistry.findLanguageVersionByTerseName((String)"jsp");
        }
        if (languageVersion != null) {
            this.getLog().debug((CharSequence)("Using language " + languageVersion));
            configuration.setDefaultLanguageVersion(languageVersion);
        }
        if (this.typeResolution) {
            this.configureTypeResolution(configuration);
        }
        if (null != this.suppressMarker) {
            configuration.setSuppressMarker(this.suppressMarker);
        }
        configuration.setBenchmark(this.benchmark);
        if (this.analysisCache) {
            configuration.setAnalysisCacheLocation(this.analysisCacheLocation);
            this.getLog().debug((CharSequence)("Using analysis cache location: " + this.analysisCacheLocation));
        } else {
            configuration.setIgnoreIncrementalAnalysis(true);
        }
        return configuration;
    }

    private void configureTypeResolution(PMDConfiguration configuration) throws MavenReportException {
        try {
            ArrayList classpath = new ArrayList();
            if (this.aggregate) {
                ArrayList<String> dependencies = new ArrayList<String>();
                ArrayList<String> exclusionPatterns = new ArrayList<String>();
                for (MavenProject localProject : this.reactorProjects) {
                    exclusionPatterns.add(localProject.getGroupId() + ":" + localProject.getArtifactId());
                }
                AndFilter filter = new AndFilter(Arrays.asList(new ExclusionsFilter(exclusionPatterns), this.includeTests ? ScopeFilter.including((String[])new String[]{"test"}) : ScopeFilter.including((String[])new String[]{"compile"})));
                for (MavenProject localProject : this.reactorProjects) {
                    DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
                    Iterable resolvedDependencies = this.dependencyResolver.resolveDependencies((ProjectBuildingRequest)buildingRequest, localProject.getModel(), (TransformableFilter)filter);
                    for (ArtifactResult resolvedArtifact : resolvedDependencies) {
                        dependencies.add(resolvedArtifact.getArtifact().getFile().toString());
                    }
                    List projectCompileClasspath = this.includeTests ? localProject.getTestClasspathElements() : localProject.getCompileClasspathElements();
                    classpath.addAll(projectCompileClasspath);
                    if (localProject.isExecutionRoot()) continue;
                    for (String path : projectCompileClasspath) {
                        File pathFile = new File(path);
                        String[] children = pathFile.list();
                        if (pathFile.exists() && (children == null || children.length != 0)) continue;
                        this.getLog().warn((CharSequence)("The project " + localProject.getArtifactId() + " does not seem to be compiled. PMD results might be inaccurate."));
                    }
                }
                classpath.addAll(dependencies);
                this.getLog().debug((CharSequence)("Using aggregated aux classpath: " + classpath));
            } else {
                classpath.addAll(this.includeTests ? this.project.getTestClasspathElements() : this.project.getCompileClasspathElements());
                this.getLog().debug((CharSequence)("Using aux classpath: " + classpath));
            }
            String path = StringUtils.join(classpath.iterator(), (String)File.pathSeparator);
            configuration.prependClasspath(path);
        }
        catch (Exception e) {
            throw new MavenReportException(e.getMessage(), e);
        }
    }

    public String getOutputName() {
        return "pmd";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("pmd-report", locale, PmdReport.class.getClassLoader());
    }

    public final Renderer createRenderer() throws MavenReportException {
        XMLRenderer result = null;
        if ("xml".equals(this.format)) {
            result = new XMLRenderer(this.getOutputEncoding());
        } else if ("txt".equals(this.format)) {
            result = new TextRenderer();
        } else if ("csv".equals(this.format)) {
            result = new CSVRenderer();
        } else if ("html".equals(this.format)) {
            result = new HTMLRenderer();
        } else if (!"".equals(this.format) && !"none".equals(this.format)) {
            try {
                result = (Renderer)Class.forName(this.format).getConstructor(Properties.class).newInstance(new Properties());
            }
            catch (Exception e) {
                throw new MavenReportException("Can't find PMD custom format " + this.format + ": " + e.getClass().getName(), e);
            }
        }
        return result;
    }
}

