/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.util.ReaderFactory;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    protected MavenProject project;
    protected MojoScanner mojoScanner;
    protected String encoding;
    protected String goalPrefix;
    protected Set extractors;

    protected abstract File getOutputDirectory();

    protected abstract Generator createGenerator();

    public void execute() throws MojoExecutionException {
        if (!"maven-plugin".equals(this.project.getPackaging())) {
            return;
        }
        String defaultGoalPrefix = PluginDescriptor.getGoalPrefixFromArtifactId((String)this.project.getArtifactId());
        if (this.goalPrefix == null) {
            this.goalPrefix = defaultGoalPrefix;
        } else if (!this.goalPrefix.equals(defaultGoalPrefix)) {
            this.getLog().warn((CharSequence)("\n\nGoal prefix is specified as: '" + this.goalPrefix + "'. " + "Maven currently expects it to be '" + defaultGoalPrefix + "'.\n"));
        }
        this.mojoScanner.setActiveExtractors(this.extractors);
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setGroupId(this.project.getGroupId());
        pluginDescriptor.setArtifactId(this.project.getArtifactId());
        pluginDescriptor.setVersion(this.project.getVersion());
        pluginDescriptor.setGoalPrefix(this.goalPrefix);
        pluginDescriptor.setName(this.project.getName());
        pluginDescriptor.setDescription(this.project.getDescription());
        if (this.encoding == null || this.encoding.length() < 1) {
            this.getLog().warn((CharSequence)("Using platform encoding (" + ReaderFactory.FILE_ENCODING + " actually) to read mojo metadata, i.e. build is platform dependent!"));
        } else {
            this.getLog().info((CharSequence)("Using '" + this.encoding + "' encoding to read mojo metadata."));
        }
        try {
            pluginDescriptor.setDependencies(PluginUtils.toComponentDependencies((List)this.project.getRuntimeDependencies()));
            DefaultPluginToolsRequest request = new DefaultPluginToolsRequest(this.project, pluginDescriptor);
            request.setEncoding(this.encoding);
            this.mojoScanner.populatePluginDescriptor((PluginToolsRequest)request);
            this.getOutputDirectory().mkdirs();
            this.createGenerator().execute(this.getOutputDirectory(), (PluginToolsRequest)request);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing plugin descriptor", (Exception)e);
        }
        catch (InvalidPluginDescriptorException e) {
            throw new MojoExecutionException("Error extracting plugin descriptor: '" + e.getLocalizedMessage() + "'", (Exception)((Object)e));
        }
        catch (ExtractionException e) {
            throw new MojoExecutionException("Error extracting plugin descriptor: '" + e.getLocalizedMessage() + "'", (Exception)((Object)e));
        }
        catch (LinkageError e) {
            throw new MojoExecutionException("The API of the mojo scanner is not compatible with this plugin version. Please check the plugin dependencies configured in the POM and ensure the versions match.", (Throwable)e);
        }
    }
}

