/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.TimeZone;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

class MetadataUtils {
    MetadataUtils() {
    }

    public static void createMetadata(File file, Artifact artifact) throws IOException {
        Xpp3Dom versions;
        Xpp3Dom versioning;
        File metadataFile;
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmss");
        fmt.setTimeZone(tz);
        String timestamp = fmt.format(new Date());
        if (artifact.isSnapshot()) {
            metadataFile = new File(file.getParentFile(), "maven-metadata-local.xml");
            Xpp3Dom metadata = new Xpp3Dom("metadata");
            MetadataUtils.addChild(metadata, "groupId", artifact.getGroupId());
            MetadataUtils.addChild(metadata, "artifactId", artifact.getArtifactId());
            MetadataUtils.addChild(metadata, "version", artifact.getBaseVersion());
            Xpp3Dom versioning2 = new Xpp3Dom("versioning");
            versioning2.addChild(MetadataUtils.addChild(new Xpp3Dom("snapshot"), "localCopy", "true"));
            MetadataUtils.addChild(versioning2, "lastUpdated", timestamp);
            metadata.addChild(versioning2);
            MetadataUtils.writeMetadata(metadataFile, metadata);
        }
        metadataFile = new File(file.getParentFile().getParentFile(), "maven-metadata-local.xml");
        LinkedHashSet<String> allVersions = new LinkedHashSet<String>();
        Xpp3Dom metadata = MetadataUtils.readMetadata(metadataFile);
        if (metadata != null && (versioning = metadata.getChild("versioning")) != null && (versions = versioning.getChild("versions")) != null) {
            Xpp3Dom[] children;
            for (Xpp3Dom aChildren : children = versions.getChildren("version")) {
                allVersions.add(aChildren.getValue());
            }
        }
        allVersions.add(artifact.getBaseVersion());
        metadata = new Xpp3Dom("metadata");
        MetadataUtils.addChild(metadata, "groupId", artifact.getGroupId());
        MetadataUtils.addChild(metadata, "artifactId", artifact.getArtifactId());
        versioning = new Xpp3Dom("versioning");
        versioning.addChild(MetadataUtils.addChildren(new Xpp3Dom("versions"), "version", allVersions));
        MetadataUtils.addChild(versioning, "lastUpdated", timestamp);
        metadata.addChild(versioning);
        metadata = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)metadata, (Xpp3Dom)MetadataUtils.readMetadata(metadataFile));
        MetadataUtils.writeMetadata(metadataFile, metadata);
    }

    private static Xpp3Dom addChild(Xpp3Dom parent, String childName, String childValue) {
        Xpp3Dom child = new Xpp3Dom(childName);
        child.setValue(childValue);
        parent.addChild(child);
        return parent;
    }

    private static Xpp3Dom addChildren(Xpp3Dom parent, String childName, Collection<String> childValues) {
        for (String childValue : childValues) {
            MetadataUtils.addChild(parent, childName, childValue);
        }
        return parent;
    }

    private static Xpp3Dom readMetadata(File metadataFile) throws IOException {
        if (!metadataFile.isFile()) {
            return null;
        }
        XmlStreamReader reader = ReaderFactory.newXmlReader((File)metadataFile);
        try {
            Xpp3Dom xpp3Dom = Xpp3DomBuilder.build((Reader)reader);
            return xpp3Dom;
        }
        catch (XmlPullParserException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMetadata(File metadataFile, Xpp3Dom metadata) throws IOException {
        metadataFile.getParentFile().mkdirs();
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)metadataFile);
        try {
            Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)metadata);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }
}

