/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectorUtils {
    SelectorUtils() {
    }

    static void parseList(String list, Collection<String> includes, Collection<String> excludes) {
        String[] tokens = list != null ? StringUtils.split((String)list, (String)",") : new String[]{};
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i].trim();
            if (token.startsWith("!")) {
                excludes.add(token.substring(1));
                continue;
            }
            includes.add(token);
        }
    }

    static boolean isOsFamily(String osSpec) {
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        SelectorUtils.parseList(osSpec, includes, excludes);
        return SelectorUtils.isOsFamily(includes, true) && !SelectorUtils.isOsFamily(excludes, false);
    }

    static boolean isOsFamily(List<String> families, boolean defaultMatch) {
        if (families != null && !families.isEmpty()) {
            for (String family : families) {
                if (!Os.isFamily((String)family)) continue;
                return true;
            }
            return false;
        }
        return defaultMatch;
    }

    static String getMavenVersion() {
        try {
            Properties properties = new Properties();
            properties.load(MavenProject.class.getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven/maven-core/pom.properties"));
            return StringUtils.trim((String)properties.getProperty("version"));
        }
        catch (Exception e) {
            return null;
        }
    }

    static String getMavenVersion(File mavenHome) {
        File[] jarFiles;
        File mavenLib = new File(mavenHome, "lib");
        for (File file : jarFiles = mavenLib.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) {
            try {
                URL url = new URL("jar:" + file.toURL().toExternalForm() + "!/META-INF/maven/org.apache.maven/maven-core/pom.properties");
                Properties properties = new Properties();
                properties.load(url.openStream());
                String version = StringUtils.trim((String)properties.getProperty("version"));
                if (version == null) continue;
                return version;
            }
            catch (MalformedURLException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    static boolean isMavenVersion(String mavenSpec) {
        return SelectorUtils.isMavenVersion(mavenSpec, SelectorUtils.getMavenVersion());
    }

    static boolean isMavenVersion(String mavenSpec, String actualVersion) {
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        SelectorUtils.parseList(mavenSpec, includes, excludes);
        List<Integer> mavenVersionList = SelectorUtils.parseVersion(actualVersion);
        return SelectorUtils.isJreVersion(mavenVersionList, includes, true) && !SelectorUtils.isJreVersion(mavenVersionList, excludes, false);
    }

    static String getJreVersion() {
        return System.getProperty("java.version", "");
    }

    static String getJreVersion(File javaHome) {
        return null;
    }

    static boolean isJreVersion(String jreSpec) {
        return SelectorUtils.isJreVersion(jreSpec, SelectorUtils.getJreVersion());
    }

    static boolean isJreVersion(String jreSpec, String actualJreVersion) {
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        SelectorUtils.parseList(jreSpec, includes, excludes);
        List<Integer> jreVersion = SelectorUtils.parseVersion(actualJreVersion);
        return SelectorUtils.isJreVersion(jreVersion, includes, true) && !SelectorUtils.isJreVersion(jreVersion, excludes, false);
    }

    static boolean isJreVersion(List<Integer> jreVersion, List<String> versionPatterns, boolean defaultMatch) {
        if (versionPatterns != null && !versionPatterns.isEmpty()) {
            for (String versionPattern : versionPatterns) {
                if (!SelectorUtils.isJreVersion(jreVersion, versionPattern)) continue;
                return true;
            }
            return false;
        }
        return defaultMatch;
    }

    static boolean isJreVersion(List<Integer> jreVersion, String versionPattern) {
        List<Integer> checkVersion = SelectorUtils.parseVersion(versionPattern);
        if (versionPattern.endsWith("+")) {
            return SelectorUtils.compareVersions(jreVersion, checkVersion) >= 0;
        }
        if (versionPattern.endsWith("-")) {
            return SelectorUtils.compareVersions(jreVersion, checkVersion) < 0;
        }
        return checkVersion.size() <= jreVersion.size() && ((Object)checkVersion).equals(jreVersion.subList(0, checkVersion.size()));
    }

    static List<Integer> parseVersion(String version) {
        version = version.replaceAll("[^0-9]", ".");
        String[] tokens = StringUtils.split((String)version, (String)".");
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (int i = 0; i < tokens.length; ++i) {
            numbers.add(Integer.valueOf(tokens[i]));
        }
        return numbers;
    }

    static int compareVersions(List<Integer> version1, List<Integer> version2) {
        Integer num2;
        Integer num1;
        int rel;
        Iterator<Integer> it1 = version1.iterator();
        Iterator<Integer> it2 = version2.iterator();
        do {
            if (!it1.hasNext()) {
                return it2.hasNext() ? -1 : 0;
            }
            if (it2.hasNext()) continue;
            return it1.hasNext() ? 1 : 0;
        } while ((rel = (num1 = it1.next()).compareTo(num2 = it2.next())) == 0);
        return rel;
    }
}

