/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.codehaus.plexus.util.StringUtils;

class InvokerProperties {
    private final Properties properties;
    private static final String PROJECT = "invoker.project";
    private static final String GOALS = "invoker.goals";
    private static final String PROFILES = "invoker.profiles";
    private static final String MAVEN_OPTS = "invoker.mavenOpts";
    private static final String FAILURE_BEHAVIOR = "invoker.failureBehavior";
    private static final String NON_RECURSIVE = "invoker.nonRecursive";
    private static final String OFFLINE = "invoker.offline";
    private static final String SYSTEM_PROPERTIES_FILE = "invoker.systemPropertiesFile";

    public InvokerProperties(Properties properties) {
        this.properties = properties != null ? properties : new Properties();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getJobName() {
        return this.properties.getProperty("invoker.name", "");
    }

    public String getJobDescription() {
        return this.properties.getProperty("invoker.description", "");
    }

    public String getJreVersion() {
        return this.properties.getProperty("invoker.java.version", "");
    }

    public String getOsFamily() {
        return this.properties.getProperty("invoker.os.family", "");
    }

    public boolean isInvocationDefined(int index) {
        String[] keys = new String[]{PROJECT, GOALS, PROFILES, MAVEN_OPTS, FAILURE_BEHAVIOR, NON_RECURSIVE, OFFLINE, SYSTEM_PROPERTIES_FILE};
        for (int i = 0; i < keys.length; ++i) {
            if (this.properties.getProperty(keys[i] + '.' + index) == null) continue;
            return true;
        }
        return false;
    }

    public void configureInvocation(InvocationRequest request, int index) {
        String offline;
        String nonRecursive;
        String failureBehavior;
        String mvnOpts;
        String profiles;
        String goals;
        String project = this.get(PROJECT, index);
        if (project != null) {
            File file = new File(request.getBaseDirectory(), project);
            if (file.isFile()) {
                request.setBaseDirectory(file.getParentFile());
                request.setPomFile(file);
            } else {
                request.setBaseDirectory(file);
                request.setPomFile(null);
            }
        }
        if ((goals = this.get(GOALS, index)) != null) {
            request.setGoals(new ArrayList<String>(Arrays.asList(StringUtils.split((String)goals, (String)", \t\n\r\f"))));
        }
        if ((profiles = this.get(PROFILES, index)) != null) {
            request.setProfiles(new ArrayList<String>(Arrays.asList(StringUtils.split((String)profiles, (String)", \t\n\r\f"))));
        }
        if ((mvnOpts = this.get(MAVEN_OPTS, index)) != null) {
            request.setMavenOpts(mvnOpts);
        }
        if ((failureBehavior = this.get(FAILURE_BEHAVIOR, index)) != null) {
            request.setFailureBehavior(failureBehavior);
        }
        if ((nonRecursive = this.get(NON_RECURSIVE, index)) != null) {
            request.setRecursive(Boolean.valueOf(nonRecursive) == false);
        }
        if ((offline = this.get(OFFLINE, index)) != null) {
            request.setOffline(Boolean.valueOf(offline).booleanValue());
        }
    }

    public boolean isExpectedResult(int exitCode, int index) {
        boolean nonZeroExit = "failure".equalsIgnoreCase(this.get("invoker.buildResult", index));
        return exitCode != 0 == nonZeroExit;
    }

    public String getSystemPropertiesFile(int index) {
        return this.get(SYSTEM_PROPERTIES_FILE, index);
    }

    String get(String key, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("invalid invocation index: " + index);
        }
        String value = this.properties.getProperty(key + '.' + index);
        if (value == null) {
            value = this.properties.getProperty(key);
        }
        return value;
    }
}

