/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.maven.plugins.help.AbstractHelpMojo;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.XmlWriterUtil;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class AbstractEffectiveMojo
extends AbstractHelpMojo {
    private static final String POM_XSD_URL = "http://maven.apache.org/maven-v4_0_0.xsd";
    private static final String SETTINGS_XSD_URL = "http://maven.apache.org/xsd/settings-1.0.0.xsd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeXmlFile(File output, String content) throws IOException {
        if (output == null) {
            return;
        }
        XmlStreamWriter out = null;
        try {
            output.getParentFile().mkdirs();
            out = WriterFactory.newXmlWriter((File)output);
            out.write(content);
            out.close();
            out = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((Writer)out);
    }

    protected static void writeHeader(XMLWriter writer) {
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        String formattedDateTime = DateFormatUtils.ISO_DATETIME_FORMAT.format(System.currentTimeMillis());
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)("Generated by Maven Help Plugin on " + formattedDateTime));
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)"See: http://maven.apache.org/plugins/maven-help-plugin/");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    protected static void writeComment(XMLWriter writer, String comment) {
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)comment);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    protected static String addMavenNamespace(String effectiveXml, boolean isPom) {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document document = builder.build((Reader)new StringReader(effectiveXml));
            Element rootElement = document.getRootElement();
            Namespace pomNamespace = Namespace.getNamespace((String)"", (String)"http://maven.apache.org/POM/4.0.0");
            rootElement.setNamespace(pomNamespace);
            Namespace xsiNamespace = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
            rootElement.addNamespaceDeclaration(xsiNamespace);
            if (rootElement.getAttribute("schemaLocation", xsiNamespace) == null) {
                rootElement.setAttribute("schemaLocation", "http://maven.apache.org/POM/4.0.0 " + (isPom ? POM_XSD_URL : SETTINGS_XSD_URL), xsiNamespace);
            }
            ElementFilter elementFilter = new ElementFilter(Namespace.getNamespace((String)""));
            Iterator i = rootElement.getDescendants((Filter)elementFilter);
            while (i.hasNext()) {
                Element e = (Element)i.next();
                e.setNamespace(pomNamespace);
            }
            StringWriter w = new StringWriter();
            Format format = Format.getPrettyFormat();
            XMLOutputter out = new XMLOutputter(format);
            out.output(document.getRootElement(), (Writer)w);
            return w.toString();
        }
        catch (JDOMException e) {
            return effectiveXml;
        }
        catch (IOException e) {
            return effectiveXml;
        }
    }

    protected static class SortedProperties
    extends Properties {
        static final long serialVersionUID = -8985316072702233744L;

        protected SortedProperties() {
        }

        @Override
        public Set<Object> keySet() {
            Set<Object> keynames = super.keySet();
            ArrayList<Object> list = new ArrayList<Object>(keynames);
            Collections.sort(list);
            return new LinkedHashSet<Object>(list);
        }
    }
}

