/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.failsafe;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.ProviderInfo;
import org.apache.maven.plugin.surefire.booterclient.ChecksumCalculator;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ForkStarter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.failsafe.model.FailsafeSummary;
import org.apache.maven.surefire.failsafe.model.io.xpp3.FailsafeSummaryXpp3Writer;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

public class IntegrationTestMojo
extends AbstractSurefireMojo {
    private boolean skipTests;
    private boolean skipITs;
    private boolean skipExec;
    private boolean skip;
    private File basedir;
    private File testClassesDirectory;
    private File classesDirectory;
    private MavenProject project;
    private List classpathDependencyExcludes;
    private String classpathDependencyScopeExclude;
    private List additionalClasspathElements;
    private File reportsDirectory;
    private File testSourceDirectory;
    private String test;
    private List includes;
    private List excludes;
    private ArtifactRepository localRepository;
    private Properties systemProperties;
    private Map systemPropertyVariables;
    private Properties properties;
    private Map pluginArtifactMap;
    private Map projectArtifactMap;
    private File summaryFile;
    private boolean printSummary;
    private String reportFormat;
    private boolean useFile;
    private boolean redirectTestOutputToFile;
    private Boolean failIfNoTests;
    private String forkMode;
    private String jvm;
    private String argLine;
    private String debugForkedProcess;
    private int forkedProcessTimeoutInSeconds;
    private Map environmentVariables = new HashMap();
    private File workingDirectory;
    private boolean childDelegation;
    private String groups;
    private String excludedGroups;
    private File[] suiteXmlFiles;
    private String junitArtifactName;
    private String testNGArtifactName;
    private int threadCount;
    private boolean perCoreThreadCount;
    private boolean useUnlimitedThreads;
    private String parallel;
    private boolean trimStackTrace;
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private List remoteRepositories;
    private ArtifactMetadataSource metadataSource;
    private Properties originalSystemProperties;
    private Properties internalSystemProperties = new Properties();
    private boolean disableXmlReport;
    private boolean useSystemClassLoader;
    private boolean useManifestOnlyJar;
    private boolean enableAssertions;
    private MavenSession session;
    private String objectFactory;
    private String encoding;
    private Boolean parallelMavenExecution;
    private String runOrder;
    private ToolchainManager toolchainManager;

    public void executeAfterPreconditionsChecked() throws MojoExecutionException, MojoFailureException {
        List providers = this.initialize();
        String exceptionMessage = null;
        FailsafeSummary result = new FailsafeSummary();
        ForkConfiguration forkConfiguration = null;
        Iterator iter = providers.iterator();
        while (iter.hasNext()) {
            ProviderInfo provider = (ProviderInfo)iter.next();
            forkConfiguration = this.getForkConfiguration();
            ClassLoaderConfiguration classLoaderConfiguration = this.getClassLoaderConfiguration(forkConfiguration);
            ForkStarter forkStarter = this.createForkStarter(provider, forkConfiguration, classLoaderConfiguration);
            try {
                result.setResult(forkStarter.run());
            }
            catch (SurefireBooterForkException e) {
                if (exceptionMessage != null) continue;
                exceptionMessage = e.getMessage();
            }
            catch (SurefireExecutionException e) {
                if (exceptionMessage != null) continue;
                exceptionMessage = e.getMessage();
            }
        }
        if (exceptionMessage != null) {
            result.setResult(255);
            result.setException(exceptionMessage);
        }
        if (this.getOriginalSystemProperties() != null && forkConfiguration != null && !forkConfiguration.isForking()) {
            System.setProperties(this.getOriginalSystemProperties());
        }
        this.writeSummary(result);
    }

    private void writeSummary(FailsafeSummary summary) throws MojoExecutionException {
        File summaryFile = this.getSummaryFile();
        if (!summaryFile.getParentFile().isDirectory()) {
            summaryFile.getParentFile().mkdirs();
        }
        try {
            String encoding;
            if (StringUtils.isEmpty((String)this.encoding)) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
                encoding = ReaderFactory.FILE_ENCODING;
            } else {
                encoding = this.encoding;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(summaryFile);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bufferedOutputStream, encoding);
            FailsafeSummaryXpp3Writer xpp3Writer = new FailsafeSummaryXpp3Writer();
            xpp3Writer.write(writer, summary);
            ((Writer)writer).close();
            bufferedOutputStream.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected boolean isSkipExecution() {
        return this.isSkip() || this.isSkipTests() || this.isSkipITs() || this.isSkipExec();
    }

    protected String getPluginName() {
        return "failsafe";
    }

    protected String[] getDefaultIncludes() {
        return new String[]{"**/IT*.java", "**/*IT.java", "**/*ITCase.java"};
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    public boolean isSkipITs() {
        return this.skipITs;
    }

    public void setSkipITs(boolean skipITs) {
        this.skipITs = skipITs;
    }

    public boolean isSkipExec() {
        return this.skipExec;
    }

    public void setSkipExec(boolean skipExec) {
        this.skipExec = skipExec;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    public void setTestClassesDirectory(File testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public List getClasspathDependencyExcludes() {
        return this.classpathDependencyExcludes;
    }

    public void setClasspathDependencyExcludes(List classpathDependencyExcludes) {
        this.classpathDependencyExcludes = classpathDependencyExcludes;
    }

    public String getClasspathDependencyScopeExclude() {
        return this.classpathDependencyScopeExclude;
    }

    public void setClasspathDependencyScopeExclude(String classpathDependencyScopeExclude) {
        this.classpathDependencyScopeExclude = classpathDependencyScopeExclude;
    }

    public List getAdditionalClasspathElements() {
        return this.additionalClasspathElements;
    }

    public void setAdditionalClasspathElements(List additionalClasspathElements) {
        this.additionalClasspathElements = additionalClasspathElements;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public File getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    public void setTestSourceDirectory(File testSourceDirectory) {
        this.testSourceDirectory = testSourceDirectory;
    }

    public String getTest() {
        if (StringUtils.isBlank((String)this.test)) {
            return null;
        }
        int index = this.test.indexOf(35);
        if (index >= 0) {
            return this.test.substring(0, index);
        }
        return this.test;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public String getTestMethod() {
        if (StringUtils.isBlank((String)this.test)) {
            return null;
        }
        int index = this.test.indexOf(35);
        if (index >= 0) {
            return this.test.substring(index + 1, this.test.length());
        }
        return null;
    }

    public List getIncludes() {
        return this.includes;
    }

    public void setIncludes(List includes) {
        this.includes = includes;
    }

    public List getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List excludes) {
        this.excludes = excludes;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Map getSystemPropertyVariables() {
        return this.systemPropertyVariables;
    }

    public void setSystemPropertyVariables(Map systemPropertyVariables) {
        this.systemPropertyVariables = systemPropertyVariables;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map getPluginArtifactMap() {
        return this.pluginArtifactMap;
    }

    public void setPluginArtifactMap(Map pluginArtifactMap) {
        this.pluginArtifactMap = pluginArtifactMap;
    }

    public Map getProjectArtifactMap() {
        return this.projectArtifactMap;
    }

    public void setProjectArtifactMap(Map projectArtifactMap) {
        this.projectArtifactMap = projectArtifactMap;
    }

    public File getSummaryFile() {
        return this.summaryFile;
    }

    public void setSummaryFile(File summaryFile) {
        this.summaryFile = summaryFile;
    }

    public boolean isPrintSummary() {
        return this.printSummary;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public void setUseFile(boolean useFile) {
        this.useFile = useFile;
    }

    public boolean isRedirectTestOutputToFile() {
        return this.redirectTestOutputToFile;
    }

    public void setRedirectTestOutputToFile(boolean redirectTestOutputToFile) {
        this.redirectTestOutputToFile = redirectTestOutputToFile;
    }

    public Boolean getFailIfNoTests() {
        return this.failIfNoTests;
    }

    public void setFailIfNoTests(Boolean failIfNoTests) {
        this.failIfNoTests = failIfNoTests;
    }

    public String getForkMode() {
        return this.forkMode;
    }

    public void setForkMode(String forkMode) {
        this.forkMode = forkMode;
    }

    public String getJvm() {
        return this.jvm;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    public String getArgLine() {
        return this.argLine;
    }

    public void setArgLine(String argLine) {
        this.argLine = argLine;
    }

    public String getDebugForkedProcess() {
        return this.debugForkedProcess;
    }

    public void setDebugForkedProcess(String debugForkedProcess) {
        this.debugForkedProcess = debugForkedProcess;
    }

    public int getForkedProcessTimeoutInSeconds() {
        return this.forkedProcessTimeoutInSeconds;
    }

    public void setForkedProcessTimeoutInSeconds(int forkedProcessTimeoutInSeconds) {
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
    }

    public Map getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public boolean isChildDelegation() {
        return this.childDelegation;
    }

    public void setChildDelegation(boolean childDelegation) {
        this.childDelegation = childDelegation;
    }

    public String getGroups() {
        return this.groups;
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public String getExcludedGroups() {
        return this.excludedGroups;
    }

    public void setExcludedGroups(String excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    public File[] getSuiteXmlFiles() {
        return this.suiteXmlFiles;
    }

    public void setSuiteXmlFiles(File[] suiteXmlFiles) {
        this.suiteXmlFiles = suiteXmlFiles;
    }

    public String getJunitArtifactName() {
        return this.junitArtifactName;
    }

    public void setJunitArtifactName(String junitArtifactName) {
        this.junitArtifactName = junitArtifactName;
    }

    public String getTestNGArtifactName() {
        return this.testNGArtifactName;
    }

    public void setTestNGArtifactName(String testNGArtifactName) {
        this.testNGArtifactName = testNGArtifactName;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public boolean getPerCoreThreadCount() {
        return this.perCoreThreadCount;
    }

    public void setPerCoreThreadCount(boolean perCoreThreadCount) {
        this.perCoreThreadCount = perCoreThreadCount;
    }

    public boolean getUseUnlimitedThreads() {
        return this.useUnlimitedThreads;
    }

    public void setUseUnlimitedThreads(boolean useUnlimitedThreads) {
        this.useUnlimitedThreads = useUnlimitedThreads;
    }

    public String getParallel() {
        return this.parallel;
    }

    public void setParallel(String parallel) {
        this.parallel = parallel;
    }

    public boolean isTrimStackTrace() {
        return this.trimStackTrace;
    }

    public void setTrimStackTrace(boolean trimStackTrace) {
        this.trimStackTrace = trimStackTrace;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void setRemoteRepositories(List remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public ArtifactMetadataSource getMetadataSource() {
        return this.metadataSource;
    }

    public void setMetadataSource(ArtifactMetadataSource metadataSource) {
        this.metadataSource = metadataSource;
    }

    public Properties getOriginalSystemProperties() {
        return this.originalSystemProperties;
    }

    public void setOriginalSystemProperties(Properties originalSystemProperties) {
        this.originalSystemProperties = originalSystemProperties;
    }

    public Properties getInternalSystemProperties() {
        return this.internalSystemProperties;
    }

    public void setInternalSystemProperties(Properties internalSystemProperties) {
        this.internalSystemProperties = internalSystemProperties;
    }

    public boolean isDisableXmlReport() {
        return this.disableXmlReport;
    }

    public void setDisableXmlReport(boolean disableXmlReport) {
        this.disableXmlReport = disableXmlReport;
    }

    public boolean isUseSystemClassLoader() {
        return this.useSystemClassLoader;
    }

    public void setUseSystemClassLoader(boolean useSystemClassLoader) {
        this.useSystemClassLoader = useSystemClassLoader;
    }

    public boolean isUseManifestOnlyJar() {
        return this.useManifestOnlyJar;
    }

    public void setUseManifestOnlyJar(boolean useManifestOnlyJar) {
        this.useManifestOnlyJar = useManifestOnlyJar;
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public String getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(String objectFactory) {
        this.objectFactory = objectFactory;
    }

    public ToolchainManager getToolchainManager() {
        return this.toolchainManager;
    }

    public void setToolchainManager(ToolchainManager toolchainManager) {
        this.toolchainManager = toolchainManager;
    }

    public boolean isTestFailureIgnore() {
        return true;
    }

    public void setTestFailureIgnore(boolean testFailureIgnore) {
    }

    public boolean isMavenParallel() {
        return this.parallelMavenExecution != null && this.parallelMavenExecution != false;
    }

    public String getRunOrder() {
        return this.runOrder;
    }

    public void setRunOrder(String runOrder) {
        this.runOrder = runOrder;
    }

    protected void addPluginSpecificChecksumItems(ChecksumCalculator checksum) {
        checksum.add(this.skipITs);
        checksum.add(this.summaryFile);
    }
}

