/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-enforcer-plugin:1.1.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Enforcer Plugin", 0);
        this.append(sb, "The Loving Iron Fist of Maven", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "display-info".equals(this.goal)) {
            this.append(sb, "enforcer:display-info", 0);
            this.append(sb, "This goal displays the current platform information.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "enforce".equals(this.goal)) {
            this.append(sb, "enforcer:enforce", 0);
            this.append(sb, "This goal executes the defined enforcer-rules once per module.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fail (Default: true)", 2);
                this.append(sb, "Flag to fail the build if a version check fails.", 3);
                this.append(sb, "Expression: ${enforcer.fail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failFast (Default: false)", 2);
                this.append(sb, "Fail on the first rule that doesn't pass", 3);
                this.append(sb, "Expression: ${enforcer.failFast}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreCache (Default: false)", 2);
                this.append(sb, "Use this flag to disable rule result caching. This will cause all rules to execute on each project even if the rule indicates it can safely be cached.", 3);
                this.append(sb, "Expression: ${enforcer.ignoreCache}", 3);
                this.append(sb, "", 0);
                this.append(sb, "rules", 2);
                this.append(sb, "Array of objects that implement the EnforcerRule interface to execute.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Flag to easily skip all checks", 3);
                this.append(sb, "Expression: ${enforcer.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "enforce-once".equals(this.goal)) {
            this.append(sb, "enforcer:enforce-once", 0);
            this.append(sb, "This goal has been deprecated.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fail (Default: true)", 2);
                this.append(sb, "Flag to fail the build if a version check fails.", 3);
                this.append(sb, "Expression: ${enforcer.fail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failFast (Default: false)", 2);
                this.append(sb, "Fail on the first rule that doesn't pass", 3);
                this.append(sb, "Expression: ${enforcer.failFast}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreCache (Default: false)", 2);
                this.append(sb, "Use this flag to disable rule result caching. This will cause all rules to execute on each project even if the rule indicates it can safely be cached.", 3);
                this.append(sb, "Expression: ${enforcer.ignoreCache}", 3);
                this.append(sb, "", 0);
                this.append(sb, "rules", 2);
                this.append(sb, "Array of objects that implement the EnforcerRule interface to execute.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Flag to easily skip all checks", 3);
                this.append(sb, "Expression: ${enforcer.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "enforcer:help", 0);
            this.append(sb, "Display help information on maven-enforcer-plugin.\nCall\n\u00a0\u00a0mvn\u00a0enforcer:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

