/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseWriterConfig;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class EclipseManifestWriter
extends AbstractEclipseWriter {
    private static final String MANIFEST_MF_FILENAME = "MANIFEST.MF";
    private static final String META_INF_DIRECTORY = "META-INF";
    private static final String GENERATED_RESOURCE_DIRNAME = "target" + File.separatorChar + "generated-resources" + File.separatorChar + "eclipse";
    private static final String WEBAPP_RESOURCE_DIR = "src" + File.separatorChar + "main" + File.separatorChar + "webapp";

    private static String getWebContentBaseDirectory(EclipseWriterConfig config) throws MojoExecutionException {
        File warSourceDirectory = new File(IdeUtils.getPluginSetting(config.getProject(), "org.apache.maven.plugins:maven-war-plugin", "warSourceDirectory", WEBAPP_RESOURCE_DIR));
        String webContentDir = IdeUtils.toRelativeAndFixSeparator(config.getEclipseProjectDirectory(), warSourceDirectory, false);
        String result = config.getProject().getBasedir().getAbsolutePath() + File.separatorChar + webContentDir;
        return result;
    }

    public String getMetaInfBaseDirectory(MavenProject project) throws MojoExecutionException {
        String metaInfBaseDirectory = null;
        if (this.config.getProject().getPackaging().equals("war")) {
            metaInfBaseDirectory = EclipseManifestWriter.getWebContentBaseDirectory(this.config);
            this.log.debug((CharSequence)("Attempting to use: " + metaInfBaseDirectory + " for location of META-INF in war project."));
            File metaInfDirectoryFile = new File(metaInfBaseDirectory + File.separatorChar + META_INF_DIRECTORY);
            if (!metaInfDirectoryFile.exists() || metaInfDirectoryFile.exists() && !metaInfDirectoryFile.isDirectory()) {
                metaInfBaseDirectory = null;
            }
        }
        for (int index = this.config.getSourceDirs().length - 1; metaInfBaseDirectory == null && index >= 0; --index) {
            File manifestFile = new File(this.config.getEclipseProjectDirectory(), this.config.getSourceDirs()[index].getPath() + File.separatorChar + META_INF_DIRECTORY + File.separatorChar + MANIFEST_MF_FILENAME);
            this.log.debug((CharSequence)("Checking for existence of META-INF/MANIFEST.MF file: " + manifestFile));
            if (!manifestFile.exists()) continue;
            metaInfBaseDirectory = manifestFile.getParentFile().getParent();
        }
        return metaInfBaseDirectory;
    }

    public void write() throws MojoExecutionException {
        File manifestFile = null;
        String metaInfBaseDirectory = this.getMetaInfBaseDirectory(this.config.getProject());
        if (metaInfBaseDirectory == null) {
            throw new MojoExecutionException(Messages.getString("EclipseCleanMojo.nofilefound", new Object[]{META_INF_DIRECTORY}));
        }
        manifestFile = new File(metaInfBaseDirectory + File.separatorChar + META_INF_DIRECTORY + File.separatorChar + MANIFEST_MF_FILENAME);
        Manifest manifest = this.createNewManifest();
        this.log.info((CharSequence)("MANIFEST LOCATION: " + manifestFile));
        if (this.shouldNewManifestFileBeWritten(manifest, manifestFile)) {
            this.log.info((CharSequence)"Writing manifest...");
            manifestFile.getParentFile().mkdirs();
            try {
                FileOutputStream stream = new FileOutputStream(manifestFile);
                manifest.write(stream);
                stream.close();
            }
            catch (Exception e) {
                this.log.error((CharSequence)Messages.getString("EclipsePlugin.cantwritetofile", new Object[]{manifestFile.getAbsolutePath()}));
            }
        }
    }

    public static void addManifestResource(Log log, EclipseWriterConfig config) throws MojoExecutionException {
        EclipseManifestWriter manifestWriter = new EclipseManifestWriter();
        manifestWriter.init(log, config);
        String packaging = config.getProject().getPackaging();
        String manifestDirectory = manifestWriter.getMetaInfBaseDirectory(config.getProject());
        if (!"ear".equals(packaging) && !"war".equals(packaging) && manifestDirectory == null) {
            String generatedResourceDir = config.getProject().getBasedir().getAbsolutePath() + File.separatorChar + GENERATED_RESOURCE_DIRNAME;
            manifestDirectory = generatedResourceDir + File.separatorChar + META_INF_DIRECTORY;
            try {
                new File(manifestDirectory).mkdirs();
                File manifestFile = new File(manifestDirectory + File.separatorChar + MANIFEST_MF_FILENAME);
                if (manifestFile.exists()) {
                    manifestFile.delete();
                }
                manifestFile.createNewFile();
            }
            catch (IOException e) {
                log.error((CharSequence)Messages.getString("EclipsePlugin.cantwritetofile", new Object[]{manifestDirectory + File.separatorChar + META_INF_DIRECTORY + File.separatorChar + MANIFEST_MF_FILENAME}));
            }
            log.debug((CharSequence)("Adding " + GENERATED_RESOURCE_DIRNAME + " to eclipse sources "));
            EclipseSourceDir[] sourceDirs = config.getSourceDirs();
            EclipseSourceDir[] newSourceDirs = new EclipseSourceDir[sourceDirs.length + 1];
            System.arraycopy(sourceDirs, 0, newSourceDirs, 0, sourceDirs.length);
            newSourceDirs[sourceDirs.length] = new EclipseSourceDir(GENERATED_RESOURCE_DIRNAME, null, true, false, null, null, false);
            config.setSourceDirs(newSourceDirs);
        }
        if ("war".equals(packaging)) {
            new File(EclipseManifestWriter.getWebContentBaseDirectory(config) + File.separatorChar + META_INF_DIRECTORY).mkdirs();
        }
        manifestWriter.write();
    }

    private void addDependencyToClassPath(StringBuffer classpath, IdeDependency dependency) {
        if (!(dependency.isTestDependency() || dependency.isProvided() || dependency.isSystemScopedOutsideProject(this.config.getProject()))) {
            if (classpath.length() != 0) {
                classpath.append(' ');
            }
            if (!dependency.isReferencedProject()) {
                classpath.append(dependency.getFile().getName());
            } else {
                classpath.append(dependency.getEclipseProjectName() + ".jar");
            }
        }
    }

    private boolean areManifestsEqual(Manifest manifest, Manifest existingManifest) {
        if (existingManifest == null) {
            return false;
        }
        HashSet<Object> keys = new HashSet<Object>();
        Attributes existingMap = existingManifest.getMainAttributes();
        Attributes newMap = manifest.getMainAttributes();
        keys.addAll(existingMap.keySet());
        keys.addAll(newMap.keySet());
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Attributes.Name key = (Attributes.Name)iterator.next();
            String newValue = (String)newMap.get(key);
            String existingValue = (String)existingMap.get(key);
            if (Attributes.Name.CLASS_PATH.equals(key)) {
                newValue = this.orderClasspath(newValue);
                existingValue = this.orderClasspath(existingValue);
            }
            if (newValue != null && newValue.equals(existingValue) || existingValue != null && existingValue.equals(newValue)) continue;
            return false;
        }
        return true;
    }

    private String constructManifestClasspath() {
        StringBuffer stringBuffer = new StringBuffer();
        IdeDependency[] deps = this.config.getDepsOrdered();
        for (int index = 0; index < deps.length; ++index) {
            this.addDependencyToClassPath(stringBuffer, deps[index]);
        }
        return stringBuffer.toString();
    }

    private Manifest createNewManifest() {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, this.constructManifestClasspath());
        return manifest;
    }

    private String orderClasspath(String newValue) {
        if (newValue == null) {
            return null;
        }
        Object[] entries = newValue.split(" ");
        Arrays.sort(entries);
        StringBuffer buffer = new StringBuffer(newValue.length());
        for (int index = 0; index < entries.length; ++index) {
            buffer.append((String)entries[index]);
            buffer.append(' ');
        }
        return buffer.toString();
    }

    private Manifest readExistingManifest(File manifestFile) throws IOException {
        if (!manifestFile.exists()) {
            return null;
        }
        Manifest existingManifest = new Manifest();
        FileInputStream inputStream = new FileInputStream(manifestFile);
        existingManifest.read(inputStream);
        inputStream.close();
        return existingManifest;
    }

    private boolean shouldNewManifestFileBeWritten(Manifest manifest, File manifestFile) throws MojoExecutionException {
        try {
            Manifest existingManifest = this.readExistingManifest(manifestFile);
            if (this.areManifestsEqual(manifest, existingManifest)) {
                this.log.info((CharSequence)Messages.getString("EclipseCleanMojo.unchanged", manifestFile.getAbsolutePath()));
                return false;
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(Messages.getString("EclipseCleanMojo.nofilefound", manifestFile.getAbsolutePath()), e);
        }
        return true;
    }
}

