/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.AbstractEarMojo;
import org.apache.maven.plugin.ear.ApplicationXmlWriter;
import org.apache.maven.plugin.ear.ApplicationXmlWriterContext;
import org.apache.maven.plugin.ear.EarPluginException;
import org.apache.maven.plugin.ear.JbossAppXmlWriter;
import org.apache.maven.plugin.ear.SecurityRole;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.util.FileUtils;

public class GenerateApplicationXmlMojo
extends AbstractEarMojo {
    private Boolean generateApplicationXml = Boolean.TRUE;
    private String displayName;
    private String description;
    private PlexusConfiguration security;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (!this.generateApplicationXml.booleanValue()) {
            this.getLog().debug((CharSequence)"Generation of application.xml is disabled");
        } else {
            if (!(this.version.equals("1.3") || this.version.equals("1.4") || this.version.equals("5") || this.version.equals("6"))) {
                throw new MojoExecutionException("Invalid version[" + this.version + "]");
            }
            this.getLog().info((CharSequence)"Generating application.xml");
            try {
                this.generateStandardDeploymentDescriptor();
            }
            catch (EarPluginException e) {
                throw new MojoExecutionException("Failed to generate application.xml", (Exception)e);
            }
            try {
                FileUtils.copyFileToDirectory((File)new File(this.generatedDescriptorLocation, "application.xml"), (File)new File(this.getWorkDirectory(), "META-INF"));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to copy application.xml to final destination", (Exception)e);
            }
        }
        if (this.getJbossConfiguration() == null) {
            this.getLog().debug((CharSequence)"Generation of jboss-app.xml is disabled");
            return;
        }
        this.getLog().info((CharSequence)"Generating jboss-app.xml");
        try {
            this.generateJbossDeploymentDescriptor();
        }
        catch (EarPluginException e) {
            throw new MojoExecutionException("Failed to generate jboss-app.xml", (Exception)e);
        }
        try {
            FileUtils.copyFileToDirectory((File)new File(this.generatedDescriptorLocation, "jboss-app.xml"), (File)new File(this.getWorkDirectory(), "META-INF"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy jboss-app.xml to final destination", (Exception)e);
        }
    }

    protected void generateStandardDeploymentDescriptor() throws EarPluginException {
        File outputDir = new File(this.generatedDescriptorLocation);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        File descriptor = new File(outputDir, "application.xml");
        ApplicationXmlWriter writer = new ApplicationXmlWriter(this.version, this.encoding);
        ApplicationXmlWriterContext context = new ApplicationXmlWriterContext(descriptor, this.getModules(), this.buildSecurityRoles(), this.displayName, this.description, this.defaultLibBundleDir);
        writer.write(context);
    }

    protected void generateJbossDeploymentDescriptor() throws EarPluginException {
        File outputDir = new File(this.generatedDescriptorLocation);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        File descriptor = new File(outputDir, "jboss-app.xml");
        JbossAppXmlWriter writer = new JbossAppXmlWriter(this.encoding);
        writer.write(descriptor, this.getJbossConfiguration(), this.getModules());
    }

    private List buildSecurityRoles() throws EarPluginException {
        ArrayList<SecurityRole> result = new ArrayList<SecurityRole>();
        if (this.security == null) {
            return result;
        }
        try {
            PlexusConfiguration[] securityRoles = this.security.getChildren("security-role");
            for (int i = 0; i < securityRoles.length; ++i) {
                PlexusConfiguration securityRole = securityRoles[i];
                String id = securityRole.getAttribute("id");
                String roleName = securityRole.getChild("role-name").getValue();
                String roleNameId = securityRole.getChild("role-name").getAttribute("id");
                String description = securityRole.getChild("description").getValue();
                String descriptionId = securityRole.getChild("description").getAttribute("id");
                if (roleName == null) {
                    throw new EarPluginException("Invalid security-role configuration, role-name could not be null.");
                }
                result.add(new SecurityRole(roleName, roleNameId, id, description, descriptionId));
            }
            return result;
        }
        catch (PlexusConfigurationException e) {
            throw new EarPluginException("Invalid security-role configuration", e);
        }
    }
}

