/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.ArtifactTypeMappingService;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.plugin.ear.EarModuleFactory;
import org.apache.maven.plugin.ear.EarPluginException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;

public abstract class AbstractEarMojo
extends AbstractMojo {
    public static final String APPLICATION_XML_URI = "META-INF/application.xml";
    public static final String META_INF = "META-INF";
    protected MavenProject project;
    private EarModule[] modules;
    protected PlexusConfiguration artifactTypeMappings;
    private String defaultJavaBundleDir;
    private File workDirectory;
    private List earModules;
    private List allModules;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Resolving artifact type mappings ...");
        try {
            ArtifactTypeMappingService.getInstance().configure(this.artifactTypeMappings);
        }
        catch (EarPluginException e) {
            throw new MojoExecutionException("Failed to initialize artifact type mappings", (Exception)e);
        }
        catch (PlexusConfigurationException e) {
            throw new MojoExecutionException("Invalid artifact type mappings configuration", (Exception)((Object)e));
        }
        this.getLog().debug((CharSequence)"Resolving ear modules ...");
        this.allModules = new ArrayList();
        try {
            if (this.modules != null && this.modules.length > 0) {
                EarModule module = null;
                for (int i = 0; i < this.modules.length; ++i) {
                    module = this.modules[i];
                    this.getLog().debug((CharSequence)("Resolving ear module[" + module + "]"));
                    module.resolveArtifact(this.project.getArtifacts(), this.defaultJavaBundleDir);
                    this.allModules.add(module);
                }
            }
            Set artifacts = this.project.getArtifacts();
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                if ("pom".equals(artifact.getType())) continue;
                ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
                if (AbstractEarMojo.isArtifactRegistered(artifact, this.allModules) || artifact.isOptional() || !filter.include(artifact)) continue;
                EarModule module = EarModuleFactory.newEarModule(artifact, this.defaultJavaBundleDir);
                this.allModules.add(module);
            }
        }
        catch (EarPluginException e) {
            throw new MojoExecutionException("Failed to initialize ear modules", (Exception)e);
        }
        this.earModules = new ArrayList();
        Iterator iter = this.allModules.iterator();
        while (iter.hasNext()) {
            EarModule earModule = (EarModule)iter.next();
            if (earModule.isExcluded()) {
                this.getLog().debug((CharSequence)("Skipping ear module[" + earModule + "]"));
                continue;
            }
            this.earModules.add(earModule);
        }
    }

    protected List getModules() {
        if (this.earModules == null) {
            throw new IllegalStateException("Ear modules have not been initialized");
        }
        return this.earModules;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected File getWorkDirectory() {
        return this.workDirectory;
    }

    private static boolean isArtifactRegistered(Artifact a, List currentList) {
        Iterator i = currentList.iterator();
        while (i.hasNext()) {
            EarModule em = (EarModule)i.next();
            if (!em.getArtifact().equals(a)) continue;
            return true;
        }
        return false;
    }
}

