/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear.output;

import org.apache.maven.plugin.ear.output.FileNameMapping;
import org.apache.maven.plugin.ear.output.FullFileNameMapping;
import org.apache.maven.plugin.ear.output.NoVersionFileNameMapping;
import org.apache.maven.plugin.ear.output.NoVersionForEjbFileNameMapping;
import org.apache.maven.plugin.ear.output.StandardFileNameMapping;

public class FileNameMappingFactory {
    static final String STANDARD_FILE_NAME_MAPPING = "standard";
    static final String FULL_FILE_NAME_MAPPING = "full";
    static final String NO_VERSION_FILE_NAME_MAPPING = "no-version";
    static final String NO_VERSION_FOR_EJB_FILE_NAME_MAPPING = "no-version-for-ejb";

    private FileNameMappingFactory() {
    }

    public static FileNameMapping getDefaultFileNameMapping() {
        return new StandardFileNameMapping();
    }

    public static FileNameMapping getFileNameMapping(String nameOrClass) {
        if (STANDARD_FILE_NAME_MAPPING.equals(nameOrClass)) {
            return FileNameMappingFactory.getDefaultFileNameMapping();
        }
        if (FULL_FILE_NAME_MAPPING.equals(nameOrClass)) {
            return new FullFileNameMapping();
        }
        if (NO_VERSION_FILE_NAME_MAPPING.equals(nameOrClass)) {
            return new NoVersionFileNameMapping();
        }
        if (NO_VERSION_FOR_EJB_FILE_NAME_MAPPING.equals(nameOrClass)) {
            return new NoVersionForEjbFileNameMapping();
        }
        try {
            Class<?> c = Class.forName(nameOrClass);
            return (FileNameMapping)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("File name mapping implementation[" + nameOrClass + "] was not found " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Could not instantiate file name mapping implementation[" + nameOrClass + "] make sure it has a default public constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access file name mapping implementation[" + nameOrClass + "] make sure it has a default public constructor");
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Specified class[" + nameOrClass + "] does not implement[" + FileNameMapping.class.getName() + "]");
        }
    }
}

