/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.deploy;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.deploy.AbstractDeployMojo;
import org.apache.maven.plugin.deploy.DeployRequest;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class DeployMojo
extends AbstractDeployMojo {
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.+)::(.+)");
    private static final AtomicInteger readyProjectsCounter = new AtomicInteger();
    private static final List<DeployRequest> deployRequests = Collections.synchronizedList(new ArrayList());
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="false", property="deployAtEnd")
    private boolean deployAtEnd;
    @Parameter(defaultValue="${project.artifact}", required=true, readonly=true)
    private Artifact artifact;
    @Parameter(defaultValue="${project.packaging}", required=true, readonly=true)
    private String packaging;
    @Parameter(defaultValue="${project.file}", required=true, readonly=true)
    private File pomFile;
    @Parameter(property="altDeploymentRepository")
    private String altDeploymentRepository;
    @Parameter(property="altSnapshotDeploymentRepository")
    private String altSnapshotDeploymentRepository;
    @Parameter(property="altReleaseDeploymentRepository")
    private String altReleaseDeploymentRepository;
    @Parameter(defaultValue="${project.attachedArtifacts}", required=true, readonly=true)
    private List attachedArtifacts;
    @Parameter(property="maven.deploy.skip", defaultValue="false")
    private boolean skip;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean projectsReady;
        boolean bl = projectsReady = readyProjectsCounter.incrementAndGet() == this.reactorProjects.size();
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping artifact deployment");
        } else {
            this.failIfOffline();
            DeployRequest currentExecutionDeployRequest = new DeployRequest().setProject(this.project).setUpdateReleaseInfo(this.isUpdateReleaseInfo()).setRetryFailedDeploymentCount(this.getRetryFailedDeploymentCount()).setAltReleaseDeploymentRepository(this.altReleaseDeploymentRepository).setAltSnapshotDeploymentRepository(this.altSnapshotDeploymentRepository).setAltDeploymentRepository(this.altDeploymentRepository);
            if (!this.deployAtEnd) {
                this.deployProject(currentExecutionDeployRequest);
            } else {
                deployRequests.add(currentExecutionDeployRequest);
                if (!projectsReady) {
                    this.getLog().info((CharSequence)("Deploying " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion() + " at end"));
                }
            }
        }
        if (projectsReady) {
            List<DeployRequest> list = deployRequests;
            synchronized (list) {
                while (!deployRequests.isEmpty()) {
                    this.deployProject(deployRequests.remove(0));
                }
            }
        }
    }

    private void deployProject(DeployRequest request) throws MojoExecutionException, MojoFailureException {
        boolean isPomArtifact;
        File sshFile;
        Artifact artifact = request.getProject().getArtifact();
        String packaging = request.getProject().getPackaging();
        File pomFile = request.getProject().getFile();
        List attachedArtifacts = request.getProject().getAttachedArtifacts();
        ArtifactRepository repo = this.getDeploymentRepository(request.getProject(), request.getAltDeploymentRepository(), request.getAltReleaseDeploymentRepository(), request.getAltSnapshotDeploymentRepository());
        String protocol = repo.getProtocol();
        if (protocol.equalsIgnoreCase("scp") && !(sshFile = new File(System.getProperty("user.home"), ".ssh")).exists()) {
            sshFile.mkdirs();
        }
        if (!(isPomArtifact = "pom".equals(packaging))) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pomFile);
            artifact.addMetadata((ArtifactMetadata)metadata);
        }
        if (request.isUpdateReleaseInfo()) {
            artifact.setRelease(true);
        }
        int retryFailedDeploymentCount = request.getRetryFailedDeploymentCount();
        try {
            if (isPomArtifact) {
                this.deploy(pomFile, artifact, repo, this.getLocalRepository(), retryFailedDeploymentCount);
            } else {
                File file = artifact.getFile();
                if (file != null && file.isFile()) {
                    this.deploy(file, artifact, repo, this.getLocalRepository(), retryFailedDeploymentCount);
                } else if (!attachedArtifacts.isEmpty()) {
                    this.getLog().info((CharSequence)"No primary artifact to deploy, deploying attached artifacts instead.");
                    Artifact pomArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion());
                    pomArtifact.setFile(pomFile);
                    if (request.isUpdateReleaseInfo()) {
                        pomArtifact.setRelease(true);
                    }
                    this.deploy(pomFile, pomArtifact, repo, this.getLocalRepository(), retryFailedDeploymentCount);
                    artifact.setResolvedVersion(pomArtifact.getVersion());
                } else {
                    String message = "The packaging for this project did not assign a file to the build artifact";
                    throw new MojoExecutionException(message);
                }
            }
            for (Artifact attached : attachedArtifacts) {
                this.deploy(attached.getFile(), attached, repo, this.getLocalRepository(), retryFailedDeploymentCount);
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    ArtifactRepository getDeploymentRepository(MavenProject project, String altDeploymentRepository, String altReleaseDeploymentRepository, String altSnapshotDeploymentRepository) throws MojoExecutionException, MojoFailureException {
        ArtifactRepository repo = null;
        String altDeploymentRepo = ArtifactUtils.isSnapshot((String)project.getVersion()) && altSnapshotDeploymentRepository != null ? altSnapshotDeploymentRepository : (!ArtifactUtils.isSnapshot((String)project.getVersion()) && altReleaseDeploymentRepository != null ? altReleaseDeploymentRepository : altDeploymentRepository);
        if (altDeploymentRepo != null) {
            this.getLog().info((CharSequence)("Using alternate deployment repository " + altDeploymentRepo));
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(altDeploymentRepo);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)altDeploymentRepo, "Invalid syntax for repository.", "Invalid syntax for alternative repository. Use \"id::layout::url\".");
            }
            String id = matcher.group(1).trim();
            String layout = matcher.group(2).trim();
            String url = matcher.group(3).trim();
            ArtifactRepositoryLayout repoLayout = this.getLayout(layout);
            repo = this.repositoryFactory.createDeploymentArtifactRepository(id, url, repoLayout, true);
        }
        if (repo == null) {
            repo = project.getDistributionManagementArtifactRepository();
        }
        if (repo == null) {
            String msg = "Deployment failed: repository element was not specified in the POM inside distributionManagement element or in -DaltDeploymentRepository=id::layout::url parameter";
            throw new MojoExecutionException(msg);
        }
        return repo;
    }
}

