/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.tree;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.tree.BuildingDependencyNodeVisitor;
import org.apache.maven.plugins.dependency.tree.DOTDependencyNodeVisitor;
import org.apache.maven.plugins.dependency.tree.GraphmlDependencyNodeVisitor;
import org.apache.maven.plugins.dependency.tree.JsonDependencyNodeVisitor;
import org.apache.maven.plugins.dependency.tree.TGFDependencyNodeVisitor;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.StrictPatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.StrictPatternIncludesArtifactFilter;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilder;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.filter.AncestorOrSelfDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.AndDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.ArtifactDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.FilteringDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.SerializingDependencyNodeVisitor;

@Mojo(name="tree", requiresDependencyCollection=ResolutionScope.TEST, threadSafe=true)
public class TreeMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Component
    private MavenSession session;
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    private String outputEncoding;
    @Component(hint="default")
    private DependencyCollectorBuilder dependencyCollectorBuilder;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Parameter(property="outputFile")
    private File outputFile;
    @Parameter(property="outputType", defaultValue="text")
    private String outputType;
    @Parameter(property="scope")
    private String scope;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="tokens", defaultValue="standard")
    private String tokens;
    @Parameter(property="includes")
    private List<String> includes;
    @Parameter(property="excludes")
    private List<String> excludes;
    private DependencyNode rootNode;
    @Parameter(property="appendOutput", defaultValue="false")
    private boolean appendOutput;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        try {
            String dependencyTreeString;
            ArtifactFilter artifactFilter = this.createResolvingArtifactFilter();
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setProject(this.project);
            if (this.verbose) {
                this.rootNode = this.dependencyCollectorBuilder.collectDependencyGraph((ProjectBuildingRequest)buildingRequest, artifactFilter);
                dependencyTreeString = this.serializeDependencyTree(this.rootNode);
            } else {
                this.rootNode = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, artifactFilter);
                dependencyTreeString = this.serializeDependencyTree(this.rootNode);
            }
            if (this.outputFile != null) {
                String encoding = Objects.toString(this.outputEncoding, "UTF-8");
                DependencyUtil.write(dependencyTreeString, this.outputFile, this.appendOutput, encoding);
                this.getLog().info((CharSequence)("Wrote dependency tree to: " + this.outputFile));
            } else {
                DependencyUtil.log(dependencyTreeString, this.getLog());
            }
        }
        catch (DependencyCollectorBuilderException | DependencyGraphBuilderException exception) {
            throw new MojoExecutionException("Cannot build project dependency graph", (Exception)exception);
        }
        catch (IOException exception) {
            throw new MojoExecutionException("Cannot serialize project dependency graph", (Exception)exception);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public DependencyNode getDependencyGraph() {
        return this.rootNode;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private ArtifactFilter createResolvingArtifactFilter() {
        ScopeArtifactFilter filter;
        if (this.scope != null) {
            this.getLog().debug((CharSequence)("+ Resolving dependency tree for scope '" + this.scope + "'"));
            filter = new ScopeArtifactFilter(this.scope);
        } else {
            filter = null;
        }
        return filter;
    }

    private String serializeDependencyTree(DependencyNode theRootNode) {
        StringWriter writer = new StringWriter();
        DependencyNodeVisitor visitor = this.getSerializingDependencyNodeVisitor(writer);
        visitor = new BuildingDependencyNodeVisitor(visitor);
        DependencyNodeFilter filter = this.createDependencyNodeFilter();
        if (filter != null) {
            CollectingDependencyNodeVisitor collectingVisitor = new CollectingDependencyNodeVisitor();
            FilteringDependencyNodeVisitor firstPassVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)collectingVisitor, filter);
            theRootNode.accept((DependencyNodeVisitor)firstPassVisitor);
            AncestorOrSelfDependencyNodeFilter secondPassFilter = new AncestorOrSelfDependencyNodeFilter(collectingVisitor.getNodes());
            visitor = new FilteringDependencyNodeVisitor(visitor, (DependencyNodeFilter)secondPassFilter);
        }
        theRootNode.accept(visitor);
        return writer.toString();
    }

    public DependencyNodeVisitor getSerializingDependencyNodeVisitor(Writer writer) {
        if ("graphml".equals(this.outputType)) {
            return new GraphmlDependencyNodeVisitor(writer);
        }
        if ("tgf".equals(this.outputType)) {
            return new TGFDependencyNodeVisitor(writer);
        }
        if ("dot".equals(this.outputType)) {
            return new DOTDependencyNodeVisitor(writer);
        }
        if ("json".equals(this.outputType)) {
            return new JsonDependencyNodeVisitor(writer);
        }
        return new SerializingDependencyNodeVisitor(writer, this.toGraphTokens(this.tokens));
    }

    private SerializingDependencyNodeVisitor.GraphTokens toGraphTokens(String theTokens) {
        SerializingDependencyNodeVisitor.GraphTokens graphTokens;
        if ("whitespace".equals(theTokens)) {
            this.getLog().debug((CharSequence)"+ Using whitespace tree tokens");
            graphTokens = SerializingDependencyNodeVisitor.WHITESPACE_TOKENS;
        } else if ("extended".equals(theTokens)) {
            this.getLog().debug((CharSequence)"+ Using extended tree tokens");
            graphTokens = SerializingDependencyNodeVisitor.EXTENDED_TOKENS;
        } else {
            graphTokens = SerializingDependencyNodeVisitor.STANDARD_TOKENS;
        }
        return graphTokens;
    }

    private DependencyNodeFilter createDependencyNodeFilter() {
        StrictPatternIncludesArtifactFilter artifactFilter;
        ArrayList<ArtifactDependencyNodeFilter> filters = new ArrayList<ArtifactDependencyNodeFilter>();
        if (this.includes != null && !this.includes.isEmpty()) {
            this.getLog().debug((CharSequence)("+ Filtering dependency tree by artifact include patterns: " + this.includes));
            artifactFilter = new StrictPatternIncludesArtifactFilter(this.includes);
            filters.add(new ArtifactDependencyNodeFilter((ArtifactFilter)artifactFilter));
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            this.getLog().debug((CharSequence)("+ Filtering dependency tree by artifact exclude patterns: " + this.excludes));
            artifactFilter = new StrictPatternExcludesArtifactFilter(this.excludes);
            filters.add(new ArtifactDependencyNodeFilter((ArtifactFilter)artifactFilter));
        }
        return filters.isEmpty() ? null : new AndDependencyNodeFilter(filters);
    }
}

