/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.utils.filters;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.plugins.dependency.utils.filters.ArtifactItemFilter;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.codehaus.plexus.util.StringUtils;

public class DestFileFilter
extends AbstractArtifactsFilter
implements ArtifactItemFilter {
    private boolean overWriteReleases;
    private boolean overWriteSnapshots;
    private boolean overWriteIfNewer;
    private boolean useSubDirectoryPerArtifact;
    private boolean useSubDirectoryPerType;
    private final boolean useSubDirectoryPerScope;
    private boolean useRepositoryLayout;
    private boolean removeVersion;
    private boolean removeClassifier;
    private final boolean prependGroupId;
    private final boolean useBaseVersion;
    private File outputFileDirectory;

    public DestFileFilter(File outputFileDirectory) {
        this(false, false, false, false, false, false, false, false, false, false, outputFileDirectory);
    }

    public DestFileFilter(boolean overWriteReleases, boolean overWriteSnapshots, boolean overWriteIfNewer, boolean useSubDirectoryPerArtifact, boolean useSubDirectoryPerType, boolean useSubDirectoryPerScope, boolean useRepositoryLayout, boolean removeVersion, boolean prependGroupId, boolean useBaseVersion, File outputFileDirectory) {
        this.overWriteReleases = overWriteReleases;
        this.overWriteSnapshots = overWriteSnapshots;
        this.overWriteIfNewer = overWriteIfNewer;
        this.useSubDirectoryPerArtifact = useSubDirectoryPerArtifact;
        this.useSubDirectoryPerType = useSubDirectoryPerType;
        this.useSubDirectoryPerScope = useSubDirectoryPerScope;
        this.useRepositoryLayout = useRepositoryLayout;
        this.removeVersion = removeVersion;
        this.prependGroupId = prependGroupId;
        this.useBaseVersion = useBaseVersion;
        this.outputFileDirectory = outputFileDirectory;
    }

    public Set<Artifact> filter(Set<Artifact> artifacts) throws ArtifactFilterException {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!this.isArtifactIncluded(new ArtifactItem(artifact))) continue;
            result.add(artifact);
        }
        return result;
    }

    public boolean isOverWriteReleases() {
        return this.overWriteReleases;
    }

    public void setOverWriteReleases(boolean overWriteReleases) {
        this.overWriteReleases = overWriteReleases;
    }

    public boolean isOverWriteSnapshots() {
        return this.overWriteSnapshots;
    }

    public void setOverWriteSnapshots(boolean overWriteSnapshots) {
        this.overWriteSnapshots = overWriteSnapshots;
    }

    public boolean isOverWriteIfNewer() {
        return this.overWriteIfNewer;
    }

    public void setOverWriteIfNewer(boolean overWriteIfNewer) {
        this.overWriteIfNewer = overWriteIfNewer;
    }

    public File getOutputFileDirectory() {
        return this.outputFileDirectory;
    }

    public void setOutputFileDirectory(File outputFileDirectory) {
        this.outputFileDirectory = outputFileDirectory;
    }

    public boolean isRemoveVersion() {
        return this.removeVersion;
    }

    public void setRemoveVersion(boolean removeVersion) {
        this.removeVersion = removeVersion;
    }

    public boolean isRemoveClassifier() {
        return this.removeClassifier;
    }

    public void setRemoveClassifier(boolean removeClassifier) {
        this.removeClassifier = removeClassifier;
    }

    public boolean isUseSubDirectoryPerArtifact() {
        return this.useSubDirectoryPerArtifact;
    }

    public void setUseSubDirectoryPerArtifact(boolean useSubDirectoryPerArtifact) {
        this.useSubDirectoryPerArtifact = useSubDirectoryPerArtifact;
    }

    public boolean isUseSubDirectoryPerType() {
        return this.useSubDirectoryPerType;
    }

    public void setUseSubDirectoryPerType(boolean useSubDirectoryPerType) {
        this.useSubDirectoryPerType = useSubDirectoryPerType;
    }

    public boolean isUseRepositoryLayout() {
        return this.useRepositoryLayout;
    }

    public void setUseRepositoryLayout(boolean useRepositoryLayout) {
        this.useRepositoryLayout = useRepositoryLayout;
    }

    @Override
    public boolean isArtifactIncluded(ArtifactItem item) throws ArtifactFilterException {
        File destFile;
        Artifact artifact = item.getArtifact();
        boolean overWrite = artifact.isSnapshot() && this.overWriteSnapshots || !artifact.isSnapshot() && this.overWriteReleases;
        File destFolder = item.getOutputDirectory();
        if (destFolder == null) {
            destFolder = DependencyUtil.getFormattedOutputDirectory(this.useSubDirectoryPerScope, this.useSubDirectoryPerType, this.useSubDirectoryPerArtifact, this.useRepositoryLayout, this.removeVersion, this.outputFileDirectory, artifact);
        }
        if (StringUtils.isEmpty((String)item.getDestFileName())) {
            String formattedFileName = DependencyUtil.getFormattedFileName(artifact, this.removeVersion, this.prependGroupId, this.useBaseVersion, this.removeClassifier);
            destFile = new File(destFolder, formattedFileName);
        } else {
            destFile = new File(destFolder, item.getDestFileName());
        }
        return overWrite || !destFile.exists() || this.overWriteIfNewer && this.getLastModified(artifact.getFile()) > this.getLastModified(destFile);
    }

    private long getLastModified(File file) throws ArtifactFilterException {
        try {
            return Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            throw new ArtifactFilterException("IO Exception", (Throwable)e);
        }
    }
}

