/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public class PurgeLocalRepositoryMojo
extends AbstractMojo {
    public static final String FILE_FUZZINESS = "file";
    public static final String VERSION_FUZZINESS = "version";
    public static final String ARTIFACT_ID_FUZZINESS = "artifactId";
    public static final String GROUP_ID_FUZZINESS = "groupId";
    private List projects;
    private List excludes;
    private String exclude;
    private boolean reResolve;
    private ArtifactRepository localRepository;
    private ArtifactResolver resolver;
    private ArtifactMetadataSource source;
    private String resolutionFuzziness;
    private boolean actTransitively;
    private ArtifactFactory factory;
    private boolean verbose;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List exclusionPatterns = this.buildExclusionPatternsList();
        for (MavenProject project : this.projects) {
            try {
                this.refreshDependenciesForProject(project, exclusionPatterns);
            }
            catch (ArtifactResolutionException e) {
                MojoFailureException failure = new MojoFailureException((Object)this, "Failed to refresh project dependencies for: " + project.getId(), "Artifact resolution failed for project: " + project.getId());
                failure.initCause((Throwable)e);
                throw failure;
            }
        }
    }

    private List buildExclusionPatternsList() {
        ArrayList<String> patterns = new ArrayList<String>();
        if (this.exclude != null) {
            String[] elements = this.exclude.split(" ?, ?");
            patterns.addAll(Arrays.asList(elements));
        } else if (this.excludes != null && !this.excludes.isEmpty()) {
            patterns.addAll(this.excludes);
        }
        return patterns;
    }

    private Map createArtifactMap(MavenProject project) {
        Map<String, Artifact> artifactMap = Collections.EMPTY_MAP;
        List dependencies = project.getDependencies();
        List remoteRepositories = Collections.EMPTY_LIST;
        HashSet<Artifact> dependencyArtifacts = new HashSet<Artifact>();
        for (Dependency dependency : dependencies) {
            VersionRange vr = VersionRange.createFromVersion((String)dependency.getVersion());
            Artifact artifact = this.factory.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), vr, dependency.getType(), dependency.getClassifier(), dependency.getScope());
            dependencyArtifacts.add(artifact);
        }
        if (this.actTransitively) {
            try {
                ArtifactResolutionResult result = this.resolver.resolveTransitively(dependencyArtifacts, project.getArtifact(), remoteRepositories, this.localRepository, this.source);
                artifactMap = ArtifactUtils.artifactMapByVersionlessId((Collection)result.getArtifacts());
            }
            catch (ArtifactResolutionException e) {
                this.verbose("Skipping: " + e.getArtifactId() + ". It cannot be resolved.");
            }
            catch (ArtifactNotFoundException e) {
                this.verbose("Skipping: " + e.getArtifactId() + ". It cannot be resolved.");
            }
        } else {
            artifactMap = new HashMap();
            for (Artifact artifact : dependencyArtifacts) {
                try {
                    this.resolver.resolve(artifact, remoteRepositories, this.localRepository);
                    artifactMap.put(ArtifactUtils.versionlessKey((Artifact)artifact), artifact);
                }
                catch (ArtifactResolutionException e) {
                    this.verbose("Skipping: " + e.getArtifactId() + ". It cannot be resolved.");
                }
                catch (ArtifactNotFoundException e) {
                    this.verbose("Skipping: " + e.getArtifactId() + ". It cannot be resolved.");
                }
            }
        }
        return artifactMap;
    }

    private void verbose(String message) {
        if (this.verbose || this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)message);
        }
    }

    private void refreshDependenciesForProject(MavenProject project, List exclusionPatterns) throws ArtifactResolutionException, MojoFailureException {
        Map deps = this.createArtifactMap(project);
        if (deps.isEmpty()) {
            this.getLog().info((CharSequence)("Nothing to do for project: " + project.getId()));
            return;
        }
        if (!exclusionPatterns.isEmpty()) {
            for (String excludedKey : exclusionPatterns) {
                if (GROUP_ID_FUZZINESS.equals(this.resolutionFuzziness)) {
                    this.verbose("Excluding groupId: " + excludedKey + " from refresh operation for project: " + project.getId());
                    Iterator deps_it = deps.entrySet().iterator();
                    while (deps_it.hasNext()) {
                        Map.Entry dependency = deps_it.next();
                        Artifact artifact = (Artifact)dependency.getValue();
                        if (!artifact.getGroupId().equals(excludedKey)) continue;
                        deps_it.remove();
                    }
                    continue;
                }
                this.verbose("Excluding: " + excludedKey + " from refresh operation for project: " + project.getId());
                deps.remove(excludedKey);
            }
        }
        this.verbose("Processing dependencies for project: " + project.getId());
        ArrayList<Artifact> missingArtifacts = new ArrayList<Artifact>();
        for (Map.Entry entry : deps.entrySet()) {
            Artifact artifact = (Artifact)entry.getValue();
            this.verbose("Processing artifact: " + artifact.getId());
            File deleteTarget = this.findDeleteTarget(artifact);
            this.verbose("Deleting: " + deleteTarget);
            if (deleteTarget.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)deleteTarget);
                }
                catch (IOException e) {
                    throw new MojoFailureException((Object)this, "Cannot delete dependency from the local repository: " + artifact.getId(), "Failed to delete: " + deleteTarget);
                }
            } else {
                deleteTarget.delete();
            }
            if (!this.reResolve) continue;
            this.verbose("Re-resolving.");
            artifact.setResolved(false);
            try {
                this.resolver.resolveAlways(artifact, project.getRemoteArtifactRepositories(), this.localRepository);
            }
            catch (ArtifactResolutionException e) {
                this.getLog().debug((CharSequence)e.getMessage());
                missingArtifacts.add(artifact);
            }
            catch (ArtifactNotFoundException e) {
                this.getLog().debug((CharSequence)e.getMessage());
                missingArtifacts.add(artifact);
            }
        }
        if (missingArtifacts.size() > 0) {
            String message = "required artifacts missing:\n";
            for (Artifact missingArtifact : missingArtifacts) {
                message = message + "  " + missingArtifact.getId() + "\n";
            }
            message = message + "\nfor the artifact:";
            throw new ArtifactResolutionException(message, project.getArtifact(), project.getRemoteArtifactRepositories());
        }
    }

    private File findDeleteTarget(Artifact artifact) {
        File deleteTarget = artifact.getFile();
        if (GROUP_ID_FUZZINESS.equals(this.resolutionFuzziness)) {
            deleteTarget = deleteTarget.getParentFile().getParentFile();
            deleteTarget = deleteTarget.getParentFile();
            String[] path = this.localRepository.pathOf(artifact).split("\\/");
            int groupParts = path.length - 4;
            File parent = deleteTarget.getParentFile();
            int count = 0;
            while (count++ < groupParts && parent.list().length < 2) {
                deleteTarget = parent;
                parent = deleteTarget.getParentFile();
            }
        } else if (ARTIFACT_ID_FUZZINESS.equals(this.resolutionFuzziness)) {
            deleteTarget = deleteTarget.getParentFile().getParentFile();
        } else if (VERSION_FUZZINESS.equals(this.resolutionFuzziness)) {
            deleteTarget = deleteTarget.getParentFile();
        }
        return deleteTarget;
    }
}

