/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.LocationManager;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;

@Mojo(name="testCompile", defaultPhase=LifecyclePhase.TEST_COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class TestCompilerMojo
extends AbstractCompilerMojo {
    @Parameter(property="maven.test.skip")
    private boolean skip;
    @Parameter(defaultValue="${project.testCompileSourceRoots}", readonly=true, required=true)
    private List<String> compileSourceRoots;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true, readonly=true)
    private File outputDirectory;
    @Parameter
    private Set<String> testIncludes = new HashSet<String>();
    @Parameter
    private Set<String> testExcludes = new HashSet<String>();
    @Parameter(property="maven.compiler.testSource")
    private String testSource;
    @Parameter(property="maven.compiler.testTarget")
    private String testTarget;
    @Parameter(property="maven.compiler.testRelease")
    private String testRelease;
    @Parameter
    private Map<String, String> testCompilerArguments;
    @Parameter
    private String testCompilerArgument;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/test-annotations")
    private File generatedTestSourcesDirectory;
    @Parameter(defaultValue="${project.testClasspathElements}", readonly=true)
    private List<String> testPath;
    final LocationManager locationManager = new LocationManager();
    private Map<String, JavaModuleDescriptor> pathElements;
    private Collection<String> classpathElements;
    private Collection<String> modulepathElements;

    @Override
    public void execute() throws MojoExecutionException, CompilationFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Not compiling test sources");
            return;
        }
        super.execute();
    }

    @Override
    protected List<String> getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    @Override
    protected Map<String, JavaModuleDescriptor> getPathElements() {
        return this.pathElements;
    }

    @Override
    protected List<String> getClasspathElements() {
        return new ArrayList<String>(this.classpathElements);
    }

    @Override
    protected List<String> getModulepathElements() {
        return new ArrayList<String>(this.modulepathElements);
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void preparePaths(Set<File> sourceFiles) {
        String root;
        Iterator<String> iterator;
        StringBuilder patchModuleValue;
        ResolvePathsResult result;
        Toolchain toolchain;
        ResolvePathsRequest request;
        File mainOutputDirectory = new File(this.getProject().getBuild().getOutputDirectory());
        File mainModuleDescriptorClassFile = new File(mainOutputDirectory, "module-info.class");
        JavaModuleDescriptor mainModuleDescriptor = null;
        File testModuleDescriptorJavaFile = new File("module-info.java");
        JavaModuleDescriptor testModuleDescriptor = null;
        for (File sourceFile : sourceFiles) {
            if (!"module-info.java".equals(sourceFile.getName())) continue;
            testModuleDescriptorJavaFile = sourceFile;
            break;
        }
        if (mainModuleDescriptorClassFile.exists()) {
            try {
                request = ResolvePathsRequest.ofStrings(this.testPath).setMainModuleDescriptor((Object)mainModuleDescriptorClassFile.getAbsolutePath());
                toolchain = this.getToolchain();
                if (toolchain instanceof DefaultJavaToolChain) {
                    request.setJdkHome((Object)((DefaultJavaToolChain)toolchain).getJavaHome());
                }
                result = this.locationManager.resolvePaths(request);
                for (Map.Entry pathException : result.getPathExceptions().entrySet()) {
                    Throwable cause = (Throwable)pathException.getValue();
                    while (cause.getCause() != null) {
                        cause = cause.getCause();
                    }
                    String fileName = Paths.get((String)pathException.getKey(), new String[0]).getFileName().toString();
                    this.getLog().warn((CharSequence)("Can't extract module name from " + fileName + ": " + cause.getMessage()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            mainModuleDescriptor = result.getMainModuleDescriptor();
            this.pathElements = new LinkedHashMap<String, JavaModuleDescriptor>(result.getPathElements().size());
            this.pathElements.putAll(result.getPathElements());
            this.modulepathElements = result.getModulepathElements().keySet();
            this.classpathElements = result.getClasspathElements();
        }
        if (testModuleDescriptorJavaFile.exists()) {
            try {
                request = ResolvePathsRequest.ofStrings(this.testPath).setMainModuleDescriptor((Object)testModuleDescriptorJavaFile.getAbsolutePath());
                toolchain = this.getToolchain();
                if (toolchain instanceof DefaultJavaToolChain) {
                    request.setJdkHome((Object)((DefaultJavaToolChain)toolchain).getJavaHome());
                }
                result = this.locationManager.resolvePaths(request);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            testModuleDescriptor = result.getMainModuleDescriptor();
        }
        if (this.release != null) {
            if (Integer.valueOf(this.release) < 9) {
                this.pathElements = Collections.emptyMap();
                this.modulepathElements = Collections.emptyList();
                this.classpathElements = this.testPath;
                return;
            }
        } else if (Double.valueOf(this.getTarget()) < Double.valueOf("1.9")) {
            this.pathElements = Collections.emptyMap();
            this.modulepathElements = Collections.emptyList();
            this.classpathElements = this.testPath;
            return;
        }
        if (testModuleDescriptor != null) {
            this.modulepathElements = this.testPath;
            this.classpathElements = Collections.emptyList();
            if (mainModuleDescriptor == null) {
                if (mainOutputDirectory.exists()) throw new UnsupportedOperationException("Can't compile test sources when main sources are missing a module descriptor");
                return;
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Main and test module descriptors exist:");
                this.getLog().debug((CharSequence)("  main module = " + mainModuleDescriptor.name()));
                this.getLog().debug((CharSequence)("  test module = " + testModuleDescriptor.name()));
            }
            if (!testModuleDescriptor.name().equals(mainModuleDescriptor.name())) {
                this.getLog().debug((CharSequence)"Black-box testing - all is ready to compile");
                return;
            }
            if (this.compilerArgs == null) {
                this.compilerArgs = new ArrayList();
            }
            this.compilerArgs.add("--patch-module");
            patchModuleValue = new StringBuilder();
            patchModuleValue.append(testModuleDescriptor.name());
            patchModuleValue.append('=');
            iterator = this.getProject().getCompileSourceRoots().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.compilerArgs.add(patchModuleValue.toString());
                    return;
                }
                root = iterator.next();
                if (!Files.exists(Paths.get(root, new String[0]), new LinkOption[0])) continue;
                patchModuleValue.append(root).append(PS);
            }
        }
        if (mainModuleDescriptor == null) {
            this.modulepathElements = Collections.emptyList();
            this.classpathElements = this.testPath;
            return;
        }
        if (this.compilerArgs == null) {
            this.compilerArgs = new ArrayList();
        }
        this.compilerArgs.add("--patch-module");
        patchModuleValue = new StringBuilder(mainModuleDescriptor.name()).append('=').append(mainOutputDirectory).append(PS);
        iterator = this.compileSourceRoots.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.compilerArgs.add(patchModuleValue.toString());
                this.compilerArgs.add("--add-reads");
                this.compilerArgs.add(mainModuleDescriptor.name() + "=ALL-UNNAMED");
                return;
            }
            root = iterator.next();
            patchModuleValue.append(root).append(PS);
        }
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner;
        if (this.testIncludes.isEmpty() && this.testExcludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (this.testIncludes.isEmpty()) {
                this.testIncludes.add("**/*.java");
            }
            scanner = new StaleSourceScanner((long)staleMillis, this.testIncludes, this.testExcludes);
        }
        return scanner;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner;
        String defaultIncludePattern = "**/*" + (inputFileEnding.startsWith(".") ? "" : ".") + inputFileEnding;
        if (this.testIncludes.isEmpty() && this.testExcludes.isEmpty()) {
            this.testIncludes = Collections.singleton(defaultIncludePattern);
            scanner = new SimpleSourceInclusionScanner(this.testIncludes, Collections.emptySet());
        } else {
            if (this.testIncludes.isEmpty()) {
                this.testIncludes.add(defaultIncludePattern);
            }
            scanner = new SimpleSourceInclusionScanner(this.testIncludes, this.testExcludes);
        }
        return scanner;
    }

    @Override
    protected String getSource() {
        return this.testSource == null ? this.source : this.testSource;
    }

    @Override
    protected String getTarget() {
        return this.testTarget == null ? this.target : this.testTarget;
    }

    @Override
    protected String getRelease() {
        return this.testRelease == null ? this.release : this.testRelease;
    }

    @Override
    protected String getCompilerArgument() {
        return this.testCompilerArgument == null ? this.compilerArgument : this.testCompilerArgument;
    }

    @Override
    protected Map<String, String> getCompilerArguments() {
        return this.testCompilerArguments == null ? this.compilerArguments : this.testCompilerArguments;
    }

    @Override
    protected File getGeneratedSourcesDirectory() {
        return this.generatedTestSourcesDirectory;
    }

    @Override
    protected boolean isTestCompile() {
        return true;
    }
}

