/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutor;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutorException;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutorRequest;
import org.apache.maven.plugin.checkstyle.CheckstyleReportGenerator;
import org.apache.maven.plugin.checkstyle.CheckstyleResults;
import org.apache.maven.plugin.checkstyle.ReportResource;
import org.apache.maven.plugin.checkstyle.rss.CheckstyleRssGenerator;
import org.apache.maven.plugin.checkstyle.rss.CheckstyleRssGeneratorRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

public class CheckstyleReport
extends AbstractMavenReport {
    public static final String PLUGIN_RESOURCES = "org/apache/maven/plugin/checkstyle";
    private static final Map<String, String> FORMAT_TO_CONFIG_LOCATION;
    private boolean skip;
    private File outputDirectory;
    private boolean enableRulesSummary;
    private boolean enableSeveritySummary;
    private boolean enableFilesSummary;
    private boolean enableRSS;
    private String includes;
    private String excludes;
    private String configLocation;
    private String format;
    private String propertiesLocation;
    private File propertiesFile;
    private URL propertiesURL;
    private String propertyExpansion;
    private String headerLocation;
    private File headerFile;
    private String cacheFile;
    private File useFile;
    protected SiteTool siteTool;
    private String suppressionsLocation;
    private String suppressionsFileExpression;
    private String suppressionsFile;
    private File outputFile;
    private String outputFileFormat;
    private String packageNamesLocation;
    private String packageNamesFile;
    private boolean failsOnError;
    private File sourceDirectory;
    private File testSourceDirectory;
    private boolean includeTestSourceDirectory;
    private MavenProject project;
    private boolean consoleOutput;
    private boolean linkXRef;
    private File xrefLocation;
    private String encoding;
    private Renderer siteRenderer;
    private ByteArrayOutputStream stringOutputStream;
    private ResourceManager locator;
    protected CheckstyleRssGenerator checkstyleRssGenerator;
    protected CheckstyleExecutor checkstyleExecutor;

    public String getName(Locale locale) {
        return CheckstyleReport.getBundle(locale).getString("report.checkstyle.name");
    }

    public String getDescription(Locale locale) {
        return CheckstyleReport.getBundle(locale).getString("report.checkstyle.description");
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        if (!this.skip) {
            this.mergeDeprecatedInfo();
            this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
            this.locator.addSearchPath("url", "");
            this.locator.setOutputDirectory(new File(this.project.getBuild().getDirectory()));
            if (!this.canGenerateReport()) {
                this.getLog().info((CharSequence)"Source directory does not exist - skipping report.");
                return;
            }
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                CheckstyleExecutorRequest request = new CheckstyleExecutorRequest();
                request.setConsoleListener(this.getConsoleListener()).setConsoleOutput(this.consoleOutput).setExcludes(this.excludes).setFailsOnError(this.failsOnError).setIncludes(this.includes).setIncludeTestSourceDirectory(this.includeTestSourceDirectory).setListener(this.getListener()).setLog(this.getLog()).setProject(this.project).setSourceDirectory(this.sourceDirectory).setStringOutputStream(this.stringOutputStream).setSuppressionsLocation(this.suppressionsLocation).setTestSourceDirectory(this.testSourceDirectory).setConfigLocation(this.configLocation).setPropertyExpansion(this.propertyExpansion).setHeaderLocation(this.headerLocation).setCacheFile(this.cacheFile).setSuppressionsFileExpression(this.suppressionsFileExpression).setEncoding(this.encoding).setPropertiesLocation(this.propertiesLocation);
                CheckstyleResults results = this.checkstyleExecutor.executeCheckstyle(request);
                ResourceBundle bundle = CheckstyleReport.getBundle(locale);
                this.generateReportStatics();
                this.generateMainReport(results, bundle);
                if (this.enableRSS) {
                    CheckstyleRssGeneratorRequest checkstyleRssGeneratorRequest = new CheckstyleRssGeneratorRequest(this.project, this.getCopyright(), this.outputDirectory, this.getLog());
                    this.checkstyleRssGenerator.generateRSS(results, checkstyleRssGeneratorRequest);
                }
            }
            catch (CheckstyleException e) {
                throw new MavenReportException("Failed during checkstyle configuration", (Exception)((Object)e));
            }
            catch (CheckstyleExecutorException e) {
                throw new MavenReportException("Failed during checkstyle execution", (Exception)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    private void generateReportStatics() throws MavenReportException {
        ReportResource rresource = new ReportResource(PLUGIN_RESOURCES, this.outputDirectory);
        try {
            rresource.copy("images/rss.png");
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to copy static resources.", (Exception)e);
        }
    }

    private String getCopyright() {
        int currentYear = Calendar.getInstance().get(1);
        String copyright = StringUtils.isNotEmpty((String)this.project.getInceptionYear()) && !String.valueOf(currentYear).equals(this.project.getInceptionYear()) ? this.project.getInceptionYear() + " - " + currentYear : String.valueOf(currentYear);
        if (this.project.getOrganization() != null && StringUtils.isNotEmpty((String)this.project.getOrganization().getName())) {
            copyright = copyright + " " + this.project.getOrganization().getName();
        }
        return copyright;
    }

    private void generateMainReport(CheckstyleResults results, ResourceBundle bundle) {
        CheckstyleReportGenerator generator = new CheckstyleReportGenerator(this.getSink(), bundle, this.project.getBasedir(), this.siteTool);
        generator.setLog(this.getLog());
        generator.setEnableRulesSummary(this.enableRulesSummary);
        generator.setEnableSeveritySummary(this.enableSeveritySummary);
        generator.setEnableFilesSummary(this.enableFilesSummary);
        generator.setEnableRSS(this.enableRSS);
        generator.setCheckstyleConfig(results.getConfiguration());
        if (this.linkXRef) {
            String relativePath = PathTool.getRelativePath((String)this.getOutputDirectory(), (String)this.xrefLocation.getAbsolutePath());
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + this.xrefLocation.getName();
            if (this.xrefLocation.exists()) {
                generator.setXrefLocation(relativePath);
            } else {
                for (ReportPlugin report : this.getProject().getReportPlugins()) {
                    String artifactId = report.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    generator.setXrefLocation(relativePath);
                }
            }
            if (generator.getXrefLocation() == null) {
                this.getLog().warn((CharSequence)"Unable to locate Source XRef to link to - DISABLED");
            }
        }
        generator.generateReport(results);
    }

    private void mergeDeprecatedInfo() {
        File defaultHeaderFile;
        if ("config/sun_checks.xml".equals(this.configLocation) && !"sun".equals(this.format)) {
            this.configLocation = FORMAT_TO_CONFIG_LOCATION.get(this.format);
        }
        if (StringUtils.isEmpty((String)this.propertiesLocation)) {
            if (this.propertiesFile != null) {
                this.propertiesLocation = this.propertiesFile.getPath();
            } else if (this.propertiesURL != null) {
                this.propertiesLocation = this.propertiesURL.toExternalForm();
            }
        }
        if ("LICENSE.txt".equals(this.headerLocation) && !(defaultHeaderFile = new File(this.project.getBasedir(), "LICENSE.txt")).equals(this.headerFile)) {
            this.headerLocation = this.headerFile.getPath();
        }
        if (StringUtils.isEmpty((String)this.suppressionsLocation)) {
            this.suppressionsLocation = this.suppressionsFile;
        }
        if (StringUtils.isEmpty((String)this.packageNamesLocation)) {
            this.packageNamesLocation = this.packageNamesFile;
        }
    }

    public String getOutputName() {
        return "checkstyle";
    }

    private AuditListener getListener() throws MavenReportException {
        XMLLogger listener = null;
        if (StringUtils.isNotEmpty((String)this.outputFileFormat)) {
            File resultFile = this.outputFile;
            OutputStream out = this.getOutputStream(resultFile);
            if ("xml".equals(this.outputFileFormat)) {
                listener = new XMLLogger(out, true);
            } else if ("plain".equals(this.outputFileFormat)) {
                listener = new DefaultLogger(out, true);
            } else {
                throw new MavenReportException("Invalid output file format: (" + this.outputFileFormat + "). Must be 'plain' or 'xml'.");
            }
        }
        return listener;
    }

    private OutputStream getOutputStream(File file) throws MavenReportException {
        FileOutputStream fileOutputStream;
        File parentFile = file.getAbsoluteFile().getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new MavenReportException("Unable to create output stream: " + file, (Exception)e);
        }
        return fileOutputStream;
    }

    private DefaultLogger getConsoleListener() throws MavenReportException {
        DefaultLogger consoleListener;
        if (this.useFile == null) {
            this.stringOutputStream = new ByteArrayOutputStream();
            consoleListener = new DefaultLogger((OutputStream)this.stringOutputStream, false);
        } else {
            OutputStream out = this.getOutputStream(this.useFile);
            consoleListener = new DefaultLogger(out, true);
        }
        return consoleListener;
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("checkstyle-report", locale, CheckstyleReport.class.getClassLoader());
    }

    public boolean canGenerateReport() {
        return this.sourceDirectory.exists() || this.includeTestSourceDirectory && this.testSourceDirectory.exists();
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        super.setReportOutputDirectory(reportOutputDirectory);
        this.outputDirectory = reportOutputDirectory;
    }

    static {
        HashMap<String, String> fmt2Cfg = new HashMap<String, String>();
        fmt2Cfg.put("sun", "config/sun_checks.xml");
        fmt2Cfg.put("turbine", "config/turbine_checks.xml");
        fmt2Cfg.put("avalon", "config/avalon_checks.xml");
        fmt2Cfg.put("maven", "config/maven_checks.xml");
        FORMAT_TO_CONFIG_LOCATION = Collections.unmodifiableMap(fmt2Cfg);
    }
}

