/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutor;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutorException;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutorRequest;
import org.apache.maven.plugin.checkstyle.CheckstyleReportGenerator;
import org.apache.maven.plugin.checkstyle.CheckstyleResults;
import org.apache.maven.plugin.checkstyle.ReportResource;
import org.apache.maven.plugin.checkstyle.rss.CheckstyleRssGenerator;
import org.apache.maven.plugin.checkstyle.rss.CheckstyleRssGeneratorRequest;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCheckstyleReport
extends AbstractMavenReport {
    public static final String PLUGIN_RESOURCES = "org/apache/maven/plugin/checkstyle";
    protected static final String JAVA_FILES = "**\\/*.java";
    @Parameter(defaultValue="${project.build.directory}/checkstyle-cachefile")
    protected String cacheFile;
    @Parameter(property="checkstyle.config.location", defaultValue="config/sun_checks.xml")
    protected String configLocation;
    @Parameter(property="checkstyle.consoleOutput", defaultValue="false")
    protected boolean consoleOutput;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(defaultValue="false")
    protected boolean failsOnError;
    @Parameter(property="checkstyle.header.file", defaultValue="LICENSE.txt")
    protected String headerLocation;
    @Parameter(property="checkstyle.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(defaultValue="${project.reporting.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter(property="checkstyle.output.file", defaultValue="${project.build.directory}/checkstyle-result.xml")
    private File outputFile;
    @Parameter(property="checkstyle.properties.location")
    protected String propertiesLocation;
    @Parameter
    protected String propertyExpansion;
    @Parameter(defaultValue="${project.resources}", readonly=true)
    protected List<Resource> resources;
    @Parameter(defaultValue="${project.testResources}", readonly=true)
    protected List<Resource> testResources;
    @Parameter(property="checkstyle.includes", defaultValue="**\\/*.java", required=true)
    protected String includes;
    @Parameter(property="checkstyle.excludes")
    protected String excludes;
    @Parameter(property="checkstyle.resourceIncludes", defaultValue="**/*.properties", required=true)
    protected String resourceIncludes;
    @Parameter(property="checkstyle.resourceExcludes")
    protected String resourceExcludes;
    @Parameter(property="checkstyle.includeResources", defaultValue="true", required=true)
    protected boolean includeResources;
    @Parameter(property="checkstyle.includeTestResources", defaultValue="true", required=true)
    protected boolean includeTestResources;
    @Parameter(defaultValue="${project.build.sourceDirectory}", required=true)
    protected File sourceDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}")
    protected File testSourceDirectory;
    @Parameter(defaultValue="false")
    protected boolean includeTestSourceDirectory;
    @Parameter(property="checkstyle.suppression.expression", defaultValue="checkstyle.suppressions.file")
    protected String suppressionsFileExpression;
    @Parameter(property="checkstyle.suppressions.location")
    protected String suppressionsLocation;
    @Parameter
    private File useFile;
    @Parameter(property="checkstyle.output.format", defaultValue="xml")
    private String outputFileFormat;
    @Parameter(property="checkstyle.enable.rules.summary", defaultValue="true")
    private boolean enableRulesSummary;
    @Parameter(property="checkstyle.enable.severity.summary", defaultValue="true")
    private boolean enableSeveritySummary;
    @Parameter(property="checkstyle.enable.files.summary", defaultValue="true")
    private boolean enableFilesSummary;
    @Parameter(property="checkstyle.enable.rss", defaultValue="true")
    private boolean enableRSS;
    @Component(role=SiteTool.class)
    protected SiteTool siteTool;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${plugin}")
    private PluginDescriptor plugin;
    @Parameter(property="linkXRef", defaultValue="true")
    private boolean linkXRef;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/xref")
    private File xrefLocation;
    @Parameter
    private List<String> treeWalkerNames;
    @Component
    private Renderer siteRenderer;
    @Component
    protected ResourceManager locator;
    @Component(role=CheckstyleRssGenerator.class, hint="default")
    protected CheckstyleRssGenerator checkstyleRssGenerator;
    @Component(role=CheckstyleExecutor.class, hint="default")
    protected CheckstyleExecutor checkstyleExecutor;
    protected ByteArrayOutputStream stringOutputStream;

    public String getName(Locale locale) {
        return AbstractCheckstyleReport.getBundle(locale).getString("report.checkstyle.name");
    }

    public String getDescription(Locale locale) {
        return AbstractCheckstyleReport.getBundle(locale).getString("report.checkstyle.description");
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
        this.locator.addSearchPath("url", "");
        this.locator.setOutputDirectory(new File(this.project.getBuild().getDirectory()));
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            CheckstyleExecutorRequest request = this.createRequest().setLicenseArtifacts(this.collectArtifacts("license")).setConfigurationArtifacts(this.collectArtifacts("configuration"));
            CheckstyleResults results = this.checkstyleExecutor.executeCheckstyle(request);
            ResourceBundle bundle = AbstractCheckstyleReport.getBundle(locale);
            this.generateReportStatics();
            this.generateMainReport(results, bundle);
            if (this.enableRSS) {
                CheckstyleRssGeneratorRequest checkstyleRssGeneratorRequest = new CheckstyleRssGeneratorRequest(this.project, this.getCopyright(), this.outputDirectory, this.getLog());
                this.checkstyleRssGenerator.generateRSS(results, checkstyleRssGeneratorRequest);
            }
        }
        catch (CheckstyleException e) {
            throw new MavenReportException("Failed during checkstyle configuration", (Exception)((Object)e));
        }
        catch (CheckstyleExecutorException e) {
            throw new MavenReportException("Failed during checkstyle execution", (Exception)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    protected abstract CheckstyleExecutorRequest createRequest() throws MavenReportException;

    private List<Artifact> collectArtifacts(String hint) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        Plugin checkstylePlugin = (Plugin)this.project.getBuild().getPluginsAsMap().get(this.plugin.getGroupId() + ":" + this.plugin.getArtifactId());
        if (checkstylePlugin != null) {
            for (Dependency dep : checkstylePlugin.getDependencies()) {
                String depKey = dep.getGroupId() + ":" + dep.getArtifactId();
                artifacts.add((Artifact)this.plugin.getArtifactMap().get(depKey));
            }
        }
        return artifacts;
    }

    protected AuditListener getListener() throws MavenReportException {
        XMLLogger listener = null;
        if (StringUtils.isNotEmpty((String)this.outputFileFormat)) {
            File resultFile = this.outputFile;
            OutputStream out = this.getOutputStream(resultFile);
            if ("xml".equals(this.outputFileFormat)) {
                listener = new XMLLogger(out, true);
            } else if ("plain".equals(this.outputFileFormat)) {
                listener = new DefaultLogger(out, true);
            } else {
                throw new MavenReportException("Invalid output file format: (" + this.outputFileFormat + "). Must be 'plain' or 'xml'.");
            }
        }
        return listener;
    }

    private OutputStream getOutputStream(File file) throws MavenReportException {
        FileOutputStream fileOutputStream;
        File parentFile = file.getAbsoluteFile().getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new MavenReportException("Unable to create output stream: " + file, (Exception)e);
        }
        return fileOutputStream;
    }

    protected DefaultLogger getConsoleListener() throws MavenReportException {
        DefaultLogger consoleListener;
        if (this.useFile == null) {
            this.stringOutputStream = new ByteArrayOutputStream();
            consoleListener = new DefaultLogger((OutputStream)this.stringOutputStream, false);
        } else {
            OutputStream out = this.getOutputStream(this.useFile);
            consoleListener = new DefaultLogger(out, true);
        }
        return consoleListener;
    }

    private void generateReportStatics() throws MavenReportException {
        ReportResource rresource = new ReportResource(PLUGIN_RESOURCES, this.outputDirectory);
        try {
            rresource.copy("images/rss.png");
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to copy static resources.", (Exception)e);
        }
    }

    private String getCopyright() {
        int currentYear = Calendar.getInstance().get(1);
        String copyright = StringUtils.isNotEmpty((String)this.project.getInceptionYear()) && !String.valueOf(currentYear).equals(this.project.getInceptionYear()) ? this.project.getInceptionYear() + " - " + currentYear : String.valueOf(currentYear);
        if (this.project.getOrganization() != null && StringUtils.isNotEmpty((String)this.project.getOrganization().getName())) {
            copyright = copyright + " " + this.project.getOrganization().getName();
        }
        return copyright;
    }

    private void generateMainReport(CheckstyleResults results, ResourceBundle bundle) {
        CheckstyleReportGenerator generator = new CheckstyleReportGenerator(this.getSink(), bundle, this.project.getBasedir(), this.siteTool);
        generator.setLog(this.getLog());
        generator.setEnableRulesSummary(this.enableRulesSummary);
        generator.setEnableSeveritySummary(this.enableSeveritySummary);
        generator.setEnableFilesSummary(this.enableFilesSummary);
        generator.setEnableRSS(this.enableRSS);
        generator.setCheckstyleConfig(results.getConfiguration());
        if (this.linkXRef) {
            String relativePath = PathTool.getRelativePath((String)this.getOutputDirectory(), (String)this.xrefLocation.getAbsolutePath());
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + this.xrefLocation.getName();
            if (this.xrefLocation.exists()) {
                generator.setXrefLocation(relativePath);
            } else {
                for (ReportPlugin report : this.getProject().getReportPlugins()) {
                    String artifactId = report.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    generator.setXrefLocation(relativePath);
                }
            }
            if (generator.getXrefLocation() == null && results.getFileCount() > 0) {
                this.getLog().warn((CharSequence)"Unable to locate Source XRef to link to - DISABLED");
            }
        }
        if (this.treeWalkerNames != null) {
            generator.setTreeWalkerNames(this.treeWalkerNames);
        }
        generator.generateReport(results);
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("checkstyle-report", locale, AbstractCheckstyleReport.class.getClassLoader());
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        super.setReportOutputDirectory(reportOutputDirectory);
        this.outputDirectory = reportOutputDirectory;
    }
}

