/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.checkstyle.AbstractCheckstyleReport;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutorRequest;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="checkstyle-aggregate", aggregator=true, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class CheckstyleAggregateReport
extends AbstractCheckstyleReport {
    @Parameter(property="checkstyle.includes", defaultValue="**\\/*.java", required=true)
    private String includes;
    @Parameter(property="checkstyle.excludes")
    private String excludes;
    @Parameter(property="checkstyle.resourceIncludes", defaultValue="**/*.properties", required=true)
    private String resourceIncludes;
    @Parameter(property="checkstyle.resourceExcludes")
    private String resourceExcludes;
    @Parameter(property="checkstyle.includeResources", defaultValue="true", required=true)
    private boolean includeResources;
    @Parameter(property="checkstyle.includeTestResources", defaultValue="true", required=true)
    private boolean includeTestResources;
    @Parameter(property="checkstyle.config.location", defaultValue="config/sun_checks.xml")
    private String configLocation;
    @Parameter(property="checkstyle.properties.location")
    private String propertiesLocation;
    @Parameter
    private String propertyExpansion;
    @Parameter(property="checkstyle.header.file", defaultValue="LICENSE.txt")
    private String headerLocation;
    @Parameter(defaultValue="${project.build.directory}/checkstyle-cachefile")
    private String cacheFile;
    @Parameter(property="checkstyle.suppressions.location")
    private String suppressionsLocation;
    @Parameter(property="checkstyle.suppression.expression", defaultValue="checkstyle.suppressions.file")
    private String suppressionsFileExpression;
    @Parameter(defaultValue="false")
    private boolean failsOnError;
    @Parameter(defaultValue="${project.build.sourceDirectory}", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}")
    private File testSourceDirectory;
    @Parameter(defaultValue="false")
    private boolean includeTestSourceDirectory;
    @Parameter(defaultValue="false")
    private boolean consoleOutput;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="reactorProjects", readonly=true)
    private List<MavenProject> reactorProjects;

    protected MavenProject getProject() {
        return this.project;
    }

    protected CheckstyleExecutorRequest createRequest() throws MavenReportException {
        CheckstyleExecutorRequest request = new CheckstyleExecutorRequest();
        request.setAggregate(true).setReactorProjects(this.reactorProjects).setConsoleListener(this.getConsoleListener()).setConsoleOutput(this.consoleOutput).setExcludes(this.excludes).setFailsOnError(this.failsOnError).setIncludes(this.includes).setIncludeResources(this.includeResources).setIncludeTestResources(this.includeTestResources).setResourceIncludes(this.resourceIncludes).setResourceExcludes(this.resourceExcludes).setIncludeTestSourceDirectory(this.includeTestSourceDirectory).setListener(this.getListener()).setLog(this.getLog()).setProject(this.project).setSourceDirectory(this.sourceDirectory).setResources(this.resources).setTestResources(this.testResources).setStringOutputStream(this.stringOutputStream).setSuppressionsLocation(this.suppressionsLocation).setTestSourceDirectory(this.testSourceDirectory).setConfigLocation(this.configLocation).setPropertyExpansion(this.propertyExpansion).setHeaderLocation(this.headerLocation).setCacheFile(this.cacheFile).setSuppressionsFileExpression(this.suppressionsFileExpression).setEncoding(this.encoding).setPropertiesLocation(this.propertiesLocation);
        return request;
    }

    public String getOutputName() {
        return "checkstyle-aggregate";
    }

    public boolean canGenerateReport() {
        return !this.skip && this.project.isExecutionRoot() && this.reactorProjects.size() > 1;
    }
}

