/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.issues;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.changes.IssueType;
import org.apache.maven.plugin.issues.IssueManagementSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIssueManagementSystem
implements IssueManagementSystem {
    protected Map<String, IssueType> issueTypeMap = new HashMap<String, IssueType>();

    protected AbstractIssueManagementSystem() {
    }

    @Override
    public Map<String, IssueType> getIssueTypeMap() {
        return this.issueTypeMap;
    }

    @Override
    public abstract String getName();

    @Override
    public void applyConfiguration(Map<String, String> issueTypes) throws MojoExecutionException {
        for (Map.Entry<String, String> me : issueTypes.entrySet()) {
            String[] imsTypeArray;
            IssueType type = IssueType.lookupByKey(me.getValue());
            if (type == null) {
                throw new MojoExecutionException("Invalid issue action " + me.getValue());
            }
            String imsTypes = me.getKey();
            for (String imsType : imsTypeArray = imsTypes.split(",")) {
                this.issueTypeMap.put(imsType, type);
            }
        }
    }
}

