/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.announcement;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.announcement.AbstractAnnouncementMojo;
import org.apache.maven.plugin.announcement.JiraDownloader;
import org.apache.maven.plugin.changes.ChangesXML;
import org.apache.maven.plugin.changes.IssueAdapter;
import org.apache.maven.plugin.changes.ProjectUtils;
import org.apache.maven.plugin.changes.ReleaseUtils;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugin.issues.IssueUtils;
import org.apache.maven.plugin.trac.TracDownloader;
import org.apache.maven.plugins.changes.model.Release;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnouncementMojo
extends AbstractAnnouncementMojo {
    private static final String CHANGES_XML = "changes.xml";
    private static final String JIRA = "JIRA";
    private static final String TRAC = "Trac";
    private String announcementFile;
    private Map announceParameters;
    private String artifactId;
    private String developmentTeam;
    private String finalName;
    private String groupId;
    private String introduction;
    private List<String> issueManagementSystems;
    private File outputDirectory;
    private String packaging;
    private MavenProject project;
    private String template;
    private String templateDirectory;
    private String templateEncoding;
    private String url;
    private String urlDownload;
    private VelocityComponent velocity;
    private String version;
    private File xmlPath;
    private String filter;
    private boolean generateJiraAnnouncement;
    private boolean jiraMerge;
    private String jiraPassword;
    private String jiraUser;
    private File jiraXML;
    private int maxEntries;
    private String resolutionIds;
    private Settings settings;
    private String statusIds;
    private String webUser;
    private String webPassword;
    private String versionPrefix;
    private String tracPassword;
    private String tracQuery;
    private String tracUser;
    private ReleaseUtils releaseUtils = new ReleaseUtils(this.getLog());
    private ChangesXML xml;

    public void execute() throws MojoExecutionException {
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the announcement generation in this project because it's not the Execution Root");
        } else {
            if (this.issueManagementSystems == null) {
                this.issueManagementSystems = new ArrayList<String>();
            }
            if (this.issueManagementSystems.isEmpty()) {
                if (this.jiraMerge) {
                    this.issueManagementSystems.add(CHANGES_XML);
                    this.issueManagementSystems.add(JIRA);
                } else if (this.generateJiraAnnouncement) {
                    this.issueManagementSystems.add(JIRA);
                } else {
                    this.issueManagementSystems.add(CHANGES_XML);
                }
            }
            List<Release> releases = null;
            if (this.issueManagementSystems.contains(CHANGES_XML)) {
                if (this.getXmlPath().exists()) {
                    ChangesXML changesXML = new ChangesXML(this.getXmlPath(), this.getLog());
                    List<Release> changesReleases = this.releaseUtils.convertReleaseList(changesXML.getReleaseList());
                    releases = this.releaseUtils.mergeReleases(releases, changesReleases);
                    this.getLog().info((CharSequence)("Including issues from file " + this.getXmlPath() + " in announcement..."));
                } else {
                    this.getLog().warn((CharSequence)("changes.xml file " + this.getXmlPath().getAbsolutePath() + " does not exist."));
                }
            }
            if (this.issueManagementSystems.contains(JIRA)) {
                if (ProjectUtils.validateIfIssueManagementComplete(this.project, JIRA, "JIRA announcement", this.getLog())) {
                    List<Release> jiraReleases = this.getJiraReleases();
                    releases = this.releaseUtils.mergeReleases(releases, jiraReleases);
                    this.getLog().info((CharSequence)"Including issues from JIRA in announcement...");
                } else {
                    throw new MojoExecutionException("Something is wrong with the Issue Management section. See previous error messages.");
                }
            }
            if (this.issueManagementSystems.contains(TRAC)) {
                if (ProjectUtils.validateIfIssueManagementComplete(this.project, TRAC, "Trac announcement", this.getLog())) {
                    List<Release> tracReleases = this.getTracReleases();
                    releases = this.releaseUtils.mergeReleases(releases, tracReleases);
                    this.getLog().info((CharSequence)"Including issues from Trac in announcement...");
                } else {
                    throw new MojoExecutionException("Something is wrong with the Issue Management section. See previous error messages.");
                }
            }
            if (releases == null || releases.isEmpty()) {
                throw new MojoExecutionException("No releases found in any of the configured issue management systems.");
            }
            this.doGenerate(releases);
        }
    }

    public void doGenerate(List<Release> releases) throws MojoExecutionException {
        String version = (this.versionPrefix == null ? "" : this.versionPrefix) + this.getVersion();
        this.doGenerate(releases, this.releaseUtils.getLatestRelease(releases, version));
    }

    protected void doGenerate(List<Release> releases, Release release) throws MojoExecutionException {
        try {
            VelocityContext context = new VelocityContext();
            if (this.getIntroduction() == null || this.getIntroduction().equals("")) {
                this.setIntroduction(this.getUrl());
            }
            context.put("releases", releases);
            context.put("groupId", (Object)this.getGroupId());
            context.put("artifactId", (Object)this.getArtifactId());
            context.put("version", (Object)this.getVersion());
            context.put("packaging", (Object)this.getPackaging());
            context.put("url", (Object)this.getUrl());
            context.put("release", (Object)release);
            context.put("introduction", (Object)this.getIntroduction());
            context.put("developmentTeam", (Object)this.getDevelopmentTeam());
            context.put("finalName", (Object)this.getFinalName());
            context.put("urlDownload", (Object)this.getUrlDownload());
            context.put("project", (Object)this.project);
            if (this.announceParameters == null) {
                context.put("announceParameters", (Object)Collections.EMPTY_MAP);
            } else {
                context.put("announceParameters", (Object)this.announceParameters);
            }
            this.processTemplate((Context)context, this.getOutputDirectory(), this.template, this.announcementFile);
        }
        catch (ResourceNotFoundException rnfe) {
            throw new MojoExecutionException("Resource not found.", (Exception)((Object)rnfe));
        }
        catch (VelocityException ve) {
            throw new MojoExecutionException(ve.toString(), (Exception)((Object)ve));
        }
    }

    public void processTemplate(Context context, File outputDirectory, String template, String announcementFile) throws ResourceNotFoundException, VelocityException, MojoExecutionException {
        if (StringUtils.isEmpty((String)announcementFile)) {
            announcementFile = template;
        }
        try {
            File f = new File(outputDirectory, announcementFile);
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            VelocityEngine engine = this.velocity.getEngine();
            engine.setApplicationAttribute((Object)"baseDirectory", (Object)this.basedir);
            if (StringUtils.isEmpty((String)this.templateEncoding)) {
                this.templateEncoding = ReaderFactory.FILE_ENCODING;
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + this.templateEncoding + ", i.e. build is platform dependent!"));
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), this.templateEncoding);
            Template velocityTemplate = engine.getTemplate(this.templateDirectory + "/" + template, this.templateEncoding);
            velocityTemplate.merge(context, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            this.getLog().info((CharSequence)("Created template " + f));
        }
        catch (ResourceNotFoundException rnfe) {
            throw new ResourceNotFoundException("Template not found. ( " + this.templateDirectory + "/" + template + " )");
        }
        catch (VelocityException ve) {
            throw new VelocityException(ve.toString());
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                this.getLog().warn(e.getCause());
            }
            throw new MojoExecutionException(e.toString(), e.getCause());
        }
    }

    protected List<Release> getJiraReleases() throws MojoExecutionException {
        JiraDownloader jiraDownloader = new JiraDownloader();
        File jiraXMLFile = this.jiraXML;
        jiraDownloader.setLog(this.getLog());
        jiraDownloader.setOutput(jiraXMLFile);
        jiraDownloader.setStatusIds(this.statusIds);
        jiraDownloader.setResolutionIds(this.resolutionIds);
        jiraDownloader.setMavenProject(this.project);
        jiraDownloader.setSettings(this.settings);
        jiraDownloader.setNbEntries(this.maxEntries);
        jiraDownloader.setFilter(this.filter);
        jiraDownloader.setJiraUser(this.jiraUser);
        jiraDownloader.setJiraPassword(this.jiraPassword);
        jiraDownloader.setWebUser(this.webUser);
        jiraDownloader.setWebPassword(this.webPassword);
        try {
            jiraDownloader.doExecute();
            List<Issue> issueList = jiraDownloader.getIssueList();
            if (StringUtils.isNotEmpty((String)this.versionPrefix)) {
                int originalNumberOfIssues = issueList.size();
                issueList = IssueUtils.filterIssuesWithVersionPrefix(issueList, this.versionPrefix);
                this.getLog().debug((CharSequence)("Filtered out " + issueList.size() + " issues of " + originalNumberOfIssues + " that matched the versionPrefix '" + this.versionPrefix + "'."));
            }
            return this.getReleases(issueList);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to extract issues from JIRA.", e);
        }
    }

    private List<Release> getReleases(List<Issue> issues) {
        if (issues.isEmpty()) {
            return Collections.emptyList();
        }
        return IssueAdapter.getReleases(issues);
    }

    protected List<Release> getTracReleases() throws MojoExecutionException {
        TracDownloader issueDownloader = new TracDownloader();
        issueDownloader.setProject(this.project);
        issueDownloader.setQuery(this.tracQuery);
        issueDownloader.setTracPassword(this.tracPassword);
        issueDownloader.setTracUser(this.tracUser);
        try {
            return this.getReleases(issueDownloader.getIssueList());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to extract issues from Trac.", e);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getDevelopmentTeam() {
        return this.developmentTeam;
    }

    public void setDevelopmentTeam(String developmentTeam) {
        this.developmentTeam = developmentTeam;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getIntroduction() {
        return this.introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlDownload() {
        return this.urlDownload;
    }

    public void setUrlDownload(String urlDownload) {
        this.urlDownload = urlDownload;
    }

    public VelocityComponent getVelocity() {
        return this.velocity;
    }

    public void setVelocity(VelocityComponent velocity) {
        this.velocity = velocity;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ChangesXML getXml() {
        return this.xml;
    }

    public void setXml(ChangesXML xml) {
        this.xml = xml;
    }

    public File getXmlPath() {
        return this.xmlPath;
    }

    public void setXmlPath(File xmlPath) {
        this.xmlPath = xmlPath;
    }
}

