/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.util.HtmlTools;
import org.apache.maven.plugin.issues.AbstractIssuesReportGenerator;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.DueTo;
import org.apache.maven.plugins.changes.model.FixedIssue;
import org.apache.maven.plugins.changes.model.Release;

public class ChangesReportGenerator
extends AbstractIssuesReportGenerator {
    private static final String URL_TOKEN = "%URL%";
    private static final String ISSUE_TOKEN = "%ISSUE%";
    static final String DEFAULT_ISSUE_SYSTEM_KEY = "default";
    private static final String NO_TEAMLIST = "none";
    private String system;
    private String teamlist;
    private String url;
    private Map issueLinksPerSystem = new HashMap();
    private boolean addActionDate;
    private boolean escapeHTML;
    private List releaseList;

    public ChangesReportGenerator() {
    }

    public ChangesReportGenerator(List releaseList) {
        this();
        this.releaseList = releaseList;
    }

    public boolean isEscapeHTML() {
        return this.escapeHTML;
    }

    public void setEscapeHTML(boolean escapeHTML) {
        this.escapeHTML = escapeHTML;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setTeamlist(String teamlist) {
        this.teamlist = teamlist;
    }

    public String getTeamlist() {
        return this.teamlist;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public Map getIssueLinksPerSystem() {
        return this.issueLinksPerSystem;
    }

    public void setIssueLinksPerSystem(Map issueLinksPerSystem) {
        if (this.issueLinksPerSystem != null && issueLinksPerSystem == null) {
            return;
        }
        this.issueLinksPerSystem = issueLinksPerSystem;
    }

    public boolean isAddActionDate() {
        return this.addActionDate;
    }

    public void setAddActionDate(boolean addActionDate) {
        this.addActionDate = addActionDate;
    }

    public boolean canGenerateIssueLinks(String system) {
        if (!this.issueLinksPerSystem.containsKey(system)) {
            return false;
        }
        String issueLink = (String)this.issueLinksPerSystem.get(system);
        if (StringUtils.isBlank((String)issueLink)) {
            return false;
        }
        return issueLink.indexOf(URL_TOKEN) < 0 || !StringUtils.isBlank((String)this.getUrl());
    }

    public void doGenerateEmptyReport(ResourceBundle bundle, Sink sink, String message) {
        this.sinkBeginReport(sink, bundle);
        sink.text(message);
        this.sinkEndReport(sink);
    }

    public void doGenerateReport(ResourceBundle bundle, Sink sink) {
        this.sinkBeginReport(sink, bundle);
        this.constructReleaseHistory(sink, bundle, this.releaseList);
        this.constructReleases(sink, bundle, this.releaseList);
        this.sinkEndReport(sink);
    }

    private void constructActions(Sink sink, List actionList, ResourceBundle bundle) {
        if (actionList.isEmpty()) {
            sink.paragraph();
            sink.text(bundle.getString("report.changes.text.no.changes"));
            sink.paragraph_();
        } else {
            sink.table();
            sink.tableRow();
            this.sinkHeader(sink, bundle.getString("report.issues.label.type"));
            this.sinkHeader(sink, bundle.getString("report.issues.label.summary"));
            this.sinkHeader(sink, bundle.getString("report.issues.label.assignee"));
            if (this.isAddActionDate()) {
                this.sinkHeader(sink, bundle.getString("report.issues.label.updated"));
            }
            sink.tableRow_();
            for (int idx = 0; idx < actionList.size(); ++idx) {
                Action action = (Action)actionList.get(idx);
                sink.tableRow();
                this.sinkShowTypeIcon(sink, action.getType());
                sink.tableCell();
                if (this.escapeHTML) {
                    sink.text(action.getAction());
                } else {
                    sink.rawText(action.getAction());
                }
                if (StringUtils.isNotEmpty((String)action.getIssue()) || !action.getFixedIssues().isEmpty()) {
                    sink.text(" " + bundle.getString("report.changes.text.fixes") + " ");
                    String system = action.getSystem();
                    if (StringUtils.isEmpty((String)system)) {
                        system = this.system;
                    }
                    if (StringUtils.isEmpty((String)system)) {
                        system = DEFAULT_ISSUE_SYSTEM_KEY;
                    }
                    if (!this.canGenerateIssueLinks(system)) {
                        this.constructIssueText(action.getIssue(), sink, action.getFixedIssues());
                    } else {
                        this.constructIssueLink(action.getIssue(), system, sink, action.getFixedIssues());
                    }
                    sink.text(".");
                }
                if (StringUtils.isNotEmpty((String)action.getDueTo()) || !action.getDueTos().isEmpty()) {
                    this.constructDueTo(sink, action, bundle, action.getDueTos());
                }
                sink.tableCell_();
                if (NO_TEAMLIST.equals(this.teamlist)) {
                    this.sinkCell(sink, action.getDev());
                } else {
                    this.sinkCellLink(sink, action.getDev(), this.teamlist + "#" + action.getDev());
                }
                if (this.isAddActionDate()) {
                    this.sinkCell(sink, action.getDate());
                }
                sink.tableRow_();
            }
            sink.table_();
        }
    }

    private void constructDueTo(Sink sink, Action action, ResourceBundle bundle, List dueTos) {
        LinkedHashMap<String, String> namesEmailMap = new LinkedHashMap<String, String>();
        if (StringUtils.isNotEmpty((String)action.getDueTo()) || StringUtils.isNotEmpty((String)action.getDueToEmail())) {
            namesEmailMap.put(action.getDueTo(), action.getDueToEmail());
        }
        Iterator iterator = dueTos.iterator();
        while (iterator.hasNext()) {
            DueTo dueTo = (DueTo)iterator.next();
            namesEmailMap.put(dueTo.getName(), dueTo.getEmail());
        }
        if (namesEmailMap.isEmpty()) {
            return;
        }
        sink.text(" " + bundle.getString("report.changes.text.thanx") + " ");
        int i = 0;
        Iterator iterator2 = namesEmailMap.keySet().iterator();
        while (iterator2.hasNext()) {
            String currentDueTo = (String)iterator2.next();
            String currentDueToEmail = (String)namesEmailMap.get(currentDueTo);
            ++i;
            if (StringUtils.isNotEmpty((String)currentDueToEmail)) {
                this.sinkLink(sink, currentDueTo, "mailto:" + currentDueToEmail);
            } else if (StringUtils.isNotEmpty((String)currentDueTo)) {
                sink.text(currentDueTo);
            }
            if (i >= namesEmailMap.size()) continue;
            sink.text(", ");
        }
        sink.text(".");
    }

    private void constructIssueLink(String issue, String system, Sink sink, List fixes) {
        if (StringUtils.isNotEmpty((String)issue)) {
            sink.link(this.parseIssueLink(issue, system));
            sink.text(issue);
            sink.link_();
            if (!fixes.isEmpty()) {
                sink.text(", ");
            }
        }
        Iterator iterator = fixes.iterator();
        while (iterator.hasNext()) {
            FixedIssue fixedIssue = (FixedIssue)iterator.next();
            String currentIssueId = fixedIssue.getIssue();
            if (StringUtils.isNotEmpty((String)currentIssueId)) {
                sink.link(this.parseIssueLink(currentIssueId, system));
                sink.text(currentIssueId);
                sink.link_();
            }
            if (!iterator.hasNext()) continue;
            sink.text(", ");
        }
    }

    private void constructIssueText(String issue, Sink sink, List fixes) {
        if (StringUtils.isNotEmpty((String)issue)) {
            sink.text(issue);
            if (!fixes.isEmpty()) {
                sink.text(", ");
            }
        }
        Iterator iterator = fixes.iterator();
        while (iterator.hasNext()) {
            FixedIssue fixedIssue = (FixedIssue)iterator.next();
            String currentIssueId = fixedIssue.getIssue();
            if (StringUtils.isNotEmpty((String)currentIssueId)) {
                sink.text(currentIssueId);
            }
            if (!iterator.hasNext()) continue;
            sink.text(", ");
        }
    }

    private void constructReleaseHistory(Sink sink, ResourceBundle bundle, List releaseList) {
        sink.section2();
        this.sinkSectionTitle2Anchor(sink, bundle.getString("report.changes.label.releasehistory"), bundle.getString("report.changes.label.releasehistory"));
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.issues.label.fixVersion"));
        this.sinkHeader(sink, bundle.getString("report.changes.label.releaseDate"));
        this.sinkHeader(sink, bundle.getString("report.changes.label.releaseDescription"));
        sink.tableRow_();
        for (int idx = 0; idx < releaseList.size(); ++idx) {
            Release release = (Release)releaseList.get(idx);
            sink.tableRow();
            this.sinkCellLink(sink, release.getVersion(), "#" + HtmlTools.encodeId((String)release.getVersion()));
            this.sinkCell(sink, release.getDateRelease());
            this.sinkCell(sink, release.getDescription());
            sink.tableRow_();
        }
        sink.table_();
        sink.section2_();
    }

    private void constructReleases(Sink sink, ResourceBundle bundle, List releaseList) {
        for (int idx = 0; idx < releaseList.size(); ++idx) {
            Release release = (Release)releaseList.get(idx);
            sink.section2();
            String date = release.getDateRelease() == null ? "" : " - " + release.getDateRelease();
            this.sinkSectionTitle2Anchor(sink, bundle.getString("report.changes.label.release") + " " + release.getVersion() + date, release.getVersion());
            this.constructActions(sink, release.getActions(), bundle);
            sink.section2_();
        }
    }

    private String parseIssueLink(String issue, String system) {
        String issueLink = (String)this.issueLinksPerSystem.get(system);
        String parseLink = issueLink.replaceFirst(ISSUE_TOKEN, issue);
        if (parseLink.indexOf(URL_TOKEN) >= 0) {
            String url = this.url.substring(0, this.url.lastIndexOf("/"));
            parseLink = parseLink.replaceFirst(URL_TOKEN, url);
        }
        return parseLink;
    }
}

