/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.announcement;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.announcement.AbstractAnnouncementMojo;
import org.apache.maven.plugin.announcement.JiraDownloader;
import org.apache.maven.plugin.changes.ChangesXML;
import org.apache.maven.plugin.jira.JiraXML;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Release;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;

public class AnnouncementMojo
extends AbstractAnnouncementMojo {
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private File outputDirectory;
    private String groupId;
    private String artifactId;
    private String version;
    private String url;
    private String packaging;
    private String finalName;
    private String urlDownload;
    private File xmlPath;
    private String developmentTeam;
    private String introduction;
    private VelocityComponent velocity;
    private String template;
    private String templateDirectory;
    private ChangesXML xml;
    private MavenProject project;
    private Settings settings;
    private boolean generateJiraAnnouncement;
    private String statusIds;
    private String resolutionIds;
    private File jiraXML;
    private int maxEntries;
    private String jiraUser;
    private String jiraPassword;
    private String templateEncoding;
    private boolean jiraMerge;
    private Map announceParameters;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the announcement generation in this project because it's not the Execution Root");
            return;
        } else if (this.jiraMerge) {
            ChangesXML changesXML = new ChangesXML(this.getXmlPath(), this.getLog());
            List changesReleases = changesXML.getReleaseList();
            if (!this.validateIfIssueManagementComplete()) throw new MojoExecutionException("Something is wrong with the Issue Management section. See previous error messages.");
            List jiraReleases = this.getJiraReleases();
            List mergedReleases = this.mergeReleases(changesReleases, jiraReleases);
            this.doGenerate(mergedReleases);
            return;
        } else if (!this.generateJiraAnnouncement) {
            if (this.getXmlPath().exists()) {
                this.setXml(new ChangesXML(this.getXmlPath(), this.getLog()));
                this.getLog().info((CharSequence)("Creating announcement file from " + this.getXmlPath() + "..."));
                this.doGenerate(this.getXml().getReleaseList());
                return;
            } else {
                this.getLog().warn((CharSequence)("changes.xml file " + this.getXmlPath().getAbsolutePath() + " does not exist."));
            }
            return;
        } else {
            this.doJiraGenerate();
        }
    }

    public void doGenerate(List releases) throws MojoExecutionException {
        this.doGenerate(releases, this.getLatestRelease(releases));
    }

    protected void doGenerate(List releases, Release release) throws MojoExecutionException {
        try {
            VelocityContext context = new VelocityContext();
            if (this.getIntroduction() == null || this.getIntroduction().equals("")) {
                this.setIntroduction(this.getUrl());
            }
            context.put("releases", (Object)releases);
            context.put("groupId", (Object)this.getGroupId());
            context.put("artifactId", (Object)this.getArtifactId());
            context.put("version", (Object)this.getVersion());
            context.put("packaging", (Object)this.getPackaging());
            context.put("url", (Object)this.getUrl());
            context.put("release", (Object)release);
            context.put("introduction", (Object)this.getIntroduction());
            context.put("developmentTeam", (Object)this.getDevelopmentTeam());
            context.put("finalName", (Object)this.getFinalName());
            context.put("urlDownload", (Object)this.getUrlDownload());
            context.put("project", (Object)this.project);
            if (this.announceParameters == null) {
                context.put("announceParameters", (Object)Collections.EMPTY_MAP);
            } else {
                context.put("announceParameters", (Object)this.announceParameters);
            }
            this.processTemplate((Context)context, this.getOutputDirectory(), this.template);
        }
        catch (ResourceNotFoundException rnfe) {
            throw new MojoExecutionException("Resource not found.", (Exception)((Object)rnfe));
        }
        catch (VelocityException ve) {
            throw new MojoExecutionException(ve.toString(), (Exception)((Object)ve));
        }
    }

    public Release getLatestRelease(List releases) throws MojoExecutionException {
        boolean isFound = false;
        Release release = null;
        String pomVersion = this.getVersion();
        if (pomVersion != null && pomVersion.endsWith(SNAPSHOT_SUFFIX)) {
            pomVersion = pomVersion.substring(0, pomVersion.length() - SNAPSHOT_SUFFIX.length());
        }
        this.getLog().debug((CharSequence)("Found " + releases.size() + " releases."));
        for (int i = 0; i < releases.size(); ++i) {
            release = (Release)releases.get(i);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("The release: " + release.getVersion() + " has " + release.getActions().size() + " actions."));
            }
            if (release.getVersion() == null || !release.getVersion().equals(pomVersion)) continue;
            isFound = true;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found the correct release: " + release.getVersion()));
                this.logRelease(release);
            }
            return release;
        }
        release = this.getRelease(releases, pomVersion);
        boolean bl = isFound = release != null;
        if (!isFound) {
            throw new MojoExecutionException("Couldn't find the release '" + pomVersion + "' among the supplied releases.");
        }
        return release;
    }

    protected Release getRelease(List releases, String version) {
        Release release = null;
        for (int i = 0; i < releases.size(); ++i) {
            release = (Release)releases.get(i);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("The release: " + release.getVersion() + " has " + release.getActions().size() + " actions."));
            }
            if (release.getVersion() == null || !release.getVersion().equals(version)) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found the correct release: " + release.getVersion()));
                this.logRelease(release);
            }
            return release;
        }
        return null;
    }

    private void logRelease(Release release) {
        Iterator iterator = release.getActions().iterator();
        while (iterator.hasNext()) {
            Action action = (Action)iterator.next();
            this.getLog().debug((CharSequence)("o " + action.getType()));
            this.getLog().debug((CharSequence)("issue : " + action.getIssue()));
            this.getLog().debug((CharSequence)("action : " + action.getAction()));
            this.getLog().debug((CharSequence)("dueTo : " + action.getDueTo()));
        }
    }

    public void processTemplate(Context context, File outputDirectory, String template) throws ResourceNotFoundException, VelocityException, MojoExecutionException {
        try {
            File f = new File(outputDirectory, template);
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            VelocityEngine engine = this.velocity.getEngine();
            engine.setApplicationAttribute((Object)"baseDirectory", (Object)this.basedir);
            if (StringUtils.isEmpty((String)this.templateEncoding)) {
                this.templateEncoding = ReaderFactory.FILE_ENCODING;
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + this.templateEncoding + ", i.e. build is platform dependent!"));
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), this.templateEncoding);
            Template velocityTemplate = engine.getTemplate(this.templateDirectory + "/" + template, this.templateEncoding);
            velocityTemplate.merge(context, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            this.getLog().info((CharSequence)("Created template " + f));
        }
        catch (ResourceNotFoundException rnfe) {
            throw new ResourceNotFoundException("Template not found. ( " + this.templateDirectory + "/" + template + " )");
        }
        catch (VelocityException ve) {
            throw new VelocityException(ve.toString());
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                this.getLog().warn(e.getCause());
            }
            throw new MojoExecutionException(e.toString(), e.getCause());
        }
    }

    public void doJiraGenerate() throws MojoExecutionException {
        if (!this.validateIfIssueManagementComplete()) {
            throw new MojoExecutionException("Something is wrong with the Issue Management section. See previous error messages.");
        }
        List releases = this.getJiraReleases();
        this.getLog().info((CharSequence)"Creating announcement file from JIRA releases...");
        this.doGenerate(releases);
    }

    protected List getJiraReleases() throws MojoExecutionException {
        JiraDownloader jiraDownloader = new JiraDownloader();
        File jiraXMLFile = this.jiraXML;
        jiraDownloader.setLog(this.getLog());
        jiraDownloader.setOutput(jiraXMLFile);
        jiraDownloader.setStatusIds(this.statusIds);
        jiraDownloader.setResolutionIds(this.resolutionIds);
        jiraDownloader.setMavenProject(this.project);
        jiraDownloader.setSettings(this.settings);
        jiraDownloader.setNbEntries(this.maxEntries);
        jiraDownloader.setJiraUser(this.jiraUser);
        jiraDownloader.setJiraPassword(this.jiraPassword);
        try {
            jiraDownloader.doExecute();
            if (jiraXMLFile.exists()) {
                JiraXML jiraParser = new JiraXML(jiraXMLFile);
                List issues = jiraParser.getIssueList();
                return JiraXML.getReleases(issues);
            }
            this.getLog().warn((CharSequence)("jira file " + jiraXMLFile.getPath() + " doesn't exists "));
            return Collections.EMPTY_LIST;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to extract JIRA issues from the downloaded file", e);
        }
    }

    protected List mergeReleases(List firstReleases, List secondReleases) {
        if (firstReleases == null && secondReleases == null) {
            return Collections.EMPTY_LIST;
        }
        if (firstReleases == null) {
            return secondReleases;
        }
        if (secondReleases == null) {
            return firstReleases;
        }
        ArrayList<Release> mergedReleases = new ArrayList<Release>();
        Iterator iterator = firstReleases.iterator();
        while (iterator.hasNext()) {
            Release firstRelease = (Release)iterator.next();
            Release secondRelease = this.getRelease(secondReleases, firstRelease.getVersion());
            if (secondRelease != null && secondRelease.getActions() != null) {
                firstRelease.getActions().addAll(secondRelease.getActions());
            }
            mergedReleases.add(firstRelease);
        }
        iterator = secondReleases.iterator();
        while (iterator.hasNext()) {
            Release secondRelease = (Release)iterator.next();
            Release mergedRelease = this.getRelease(mergedReleases, secondRelease.getVersion());
            if (mergedRelease != null) continue;
            mergedReleases.add(secondRelease);
        }
        return mergedReleases;
    }

    private boolean validateIfIssueManagementComplete() {
        if (this.project.getIssueManagement() == null) {
            this.getLog().error((CharSequence)"No Issue Management set. No JIRA announcement will be made.");
            return false;
        }
        if (this.project.getIssueManagement().getUrl() == null || this.project.getIssueManagement().getUrl().trim().equals("")) {
            this.getLog().error((CharSequence)"No URL set in Issue Management. No JIRA announcement will be made.");
            return false;
        }
        if (this.project.getIssueManagement().getSystem() != null && !this.project.getIssueManagement().getSystem().equalsIgnoreCase("jira")) {
            this.getLog().error((CharSequence)"No JIRA Issue Management system configured. No JIRA announcement will be made.");
            return false;
        }
        return true;
    }

    public File getXmlPath() {
        return this.xmlPath;
    }

    public void setXmlPath(File xmlPath) {
        this.xmlPath = xmlPath;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ChangesXML getXml() {
        return this.xml;
    }

    public void setXml(ChangesXML xml) {
        this.xml = xml;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getDevelopmentTeam() {
        return this.developmentTeam;
    }

    public void setDevelopmentTeam(String developmentTeam) {
        this.developmentTeam = developmentTeam;
    }

    public String getIntroduction() {
        return this.introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public VelocityComponent getVelocity() {
        return this.velocity;
    }

    public void setVelocity(VelocityComponent velocity) {
        this.velocity = velocity;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    public String getUrlDownload() {
        return this.urlDownload;
    }

    public void setUrlDownload(String urlDownload) {
        this.urlDownload = urlDownload;
    }
}

