/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugin.jira.AbstractJiraDownloader;
import org.apache.maven.plugin.jira.JiraHelper;
import org.apache.maven.plugin.jira.JiraXML;
import org.apache.maven.plugin.jira.JqlQueryBuilder;
import org.apache.maven.plugin.jira.ParameterQueryBuilder;
import org.apache.maven.plugin.jira.UrlBuilder;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public final class ClassicJiraDownloader
extends AbstractJiraDownloader {
    @Override
    public void doExecute() throws Exception {
        try {
            HttpClient client = new HttpClient();
            HttpClientParams clientParams = client.getParams();
            clientParams.setBooleanParameter("http.protocol.allow-circular-redirects", true);
            clientParams.setCookiePolicy("compatibility");
            HttpState state = new HttpState();
            HostConfiguration hc = new HostConfiguration();
            client.setHostConfiguration(hc);
            client.setState(state);
            String baseUrl = JiraHelper.getBaseUrl(this.project.getIssueManagement().getUrl());
            this.getLog().debug((CharSequence)("JIRA lives at: " + baseUrl));
            this.determineProxy(baseUrl, client);
            this.prepareBasicAuthentication(client);
            boolean jiraAuthenticationSuccessful = false;
            if (this.isJiraAuthenticationConfigured()) {
                jiraAuthenticationSuccessful = this.doJiraAuthentication(client, baseUrl);
            }
            if (this.isJiraAuthenticationConfigured() && jiraAuthenticationSuccessful || !this.isJiraAuthenticationConfigured()) {
                String fullUrl = this.useJql ? this.getJqlQueryURL() : this.getParameterBasedQueryURL(client);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("download jira issues from url " + fullUrl));
                }
                this.download(client, fullUrl);
            }
        }
        catch (Exception e) {
            if (this.project.getIssueManagement() != null) {
                this.getLog().error((CharSequence)("Error accessing " + this.project.getIssueManagement().getUrl()), (Throwable)e);
            }
            this.getLog().error((CharSequence)"Error accessing mock project issues", (Throwable)e);
        }
    }

    private String getJqlQueryURL() {
        Map<String, String> urlMap = JiraHelper.getJiraUrlAndProjectName(this.project.getIssueManagement().getUrl());
        String jiraUrl = urlMap.get("url");
        String jiraProject = urlMap.get("project");
        if (jiraProject == null) {
            throw new RuntimeException("The issue management URL in the POM does not include a JIRA project name");
        }
        String jqlQuery = new JqlQueryBuilder(this.log).project(jiraProject).fixVersion(this.getFixFor()).fixVersionIds(this.fixVersionIds).statusIds(this.statusIds).priorityIds(this.priorityIds).resolutionIds(this.resolutionIds).components(this.component).typeIds(this.typeIds).sortColumnNames(this.sortColumnNames).build();
        String url = new UrlBuilder(jiraUrl, "sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml").addParameter("tempMax", this.nbEntriesMax).addParameter("reset", "true").addParameter("jqlQuery", jqlQuery).build();
        return url;
    }

    private String getParameterBasedQueryURL(HttpClient client) {
        String createdFilter;
        Map<String, String> urlMap = JiraHelper.getJiraUrlAndProjectId(this.project.getIssueManagement().getUrl());
        String jiraUrl = urlMap.get("url");
        String jiraId = urlMap.get("id");
        if (jiraId == null || jiraId.length() == 0) {
            this.log.debug((CharSequence)("The JIRA URL " + this.project.getIssueManagement().getUrl() + " doesn't include a pid, trying to extract it from JIRA."));
            jiraId = JiraHelper.getPidFromJira(this.log, this.project.getIssueManagement().getUrl(), client);
        }
        if (jiraId == null) {
            throw new RuntimeException("The issue management URL in the POM does not include a pid, and it was not possible to extract it from the page at that URL.");
        }
        String fullURL = jiraUrl + "/secure/IssueNavigator.jspa?view=rss&pid=" + jiraId;
        if (this.getFixFor() != null) {
            fullURL = fullURL + "&fixfor=" + this.getFixFor();
        }
        if ((createdFilter = new ParameterQueryBuilder(this.log).fixVersionIds(this.fixVersionIds).statusIds(this.statusIds).priorityIds(this.priorityIds).resolutionIds(this.resolutionIds).components(this.component).typeIds(this.typeIds).sortColumnNames(this.sortColumnNames).filter(this.filter).build()).charAt(0) != '&') {
            fullURL = fullURL + "&";
        }
        fullURL = fullURL + createdFilter;
        fullURL = fullURL + "&tempMax=" + this.nbEntriesMax + "&reset=true&decorator=none";
        return fullURL;
    }

    private void prepareBasicAuthentication(HttpClient client) {
        if (this.webUser != null && this.webUser.length() > 0) {
            client.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.webUser, this.webPassword);
            this.getLog().debug((CharSequence)("Using username: " + this.webUser + " for Basic Authentication."));
            client.getState().setCredentials(new AuthScope(null, -1, null, AuthScope.ANY_SCHEME), (Credentials)defaultcreds);
        }
    }

    private boolean doJiraAuthentication(HttpClient client, String jiraUrl) {
        StringBuilder loginLink = new StringBuilder(jiraUrl);
        loginLink.append("/login.jsp?os_destination=/secure/");
        try {
            loginLink.append("&os_username=").append(URLEncoder.encode(this.jiraUser, "UTF-8"));
            String password = null;
            if (this.jiraPassword != null) {
                password = StringUtils.repeat((String)"*", (int)this.jiraPassword.length());
            }
            this.getLog().debug((CharSequence)("Login URL: " + loginLink + "&os_password=" + password));
            loginLink.append("&os_password=").append(URLEncoder.encode(this.jiraPassword, "UTF-8"));
            String loginUrl = loginLink.toString();
            GetMethod loginGet = new GetMethod(loginUrl);
            client.executeMethod((HttpMethod)loginGet);
            if (this.loginSucceeded(loginGet)) {
                this.getLog().debug((CharSequence)"Successfully logged in into JIRA.");
                return true;
            }
            this.getLog().warn((CharSequence)"Was unable to login into JIRA: wrong username and/or password.");
        }
        catch (Exception e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)"Error trying to login into JIRA.", (Throwable)e);
            }
            this.getLog().error((CharSequence)("Error trying to login into JIRA. Cause is: " + e.getLocalizedMessage()));
        }
        return false;
    }

    private boolean loginSucceeded(GetMethod loginGet) throws IOException {
        String loginFailureResponse = "your username and password are incorrect";
        return !loginGet.getResponseBodyAsString().contains("your username and password are incorrect");
    }

    private void determineProxy(String jiraUrl, HttpClient client) {
        this.getProxyInfo(jiraUrl);
        if (this.proxyHost != null) {
            client.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort);
            this.getLog().debug((CharSequence)("Using proxy: " + this.proxyHost + " at port " + this.proxyPort));
            if (this.proxyUser != null) {
                this.getLog().debug((CharSequence)("Using proxy user: " + this.proxyUser));
                client.getState().setProxyCredentials(new AuthScope(null, -1, null, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(this.proxyUser, this.proxyPass));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void download(HttpClient cl, String link) {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            GetMethod gm = new GetMethod(link);
            this.getLog().info((CharSequence)("Downloading from JIRA at: " + link));
            gm.setFollowRedirects(true);
            cl.executeMethod((HttpMethod)gm);
            StatusLine sl = gm.getStatusLine();
            if (sl == null) {
                this.getLog().error((CharSequence)("Unknown error validating link: " + link));
                IOUtil.close(out);
                IOUtil.close((InputStream)in);
                return;
            }
            if (gm.getStatusCode() == 302) {
                Header locationHeader = gm.getResponseHeader("Location");
                if (locationHeader == null) {
                    this.getLog().warn((CharSequence)"Site sent redirect, but did not set Location header");
                } else {
                    String newLink = locationHeader.getValue();
                    this.getLog().debug((CharSequence)("Following redirect to " + newLink));
                    this.download(cl, newLink);
                }
            }
            if (gm.getStatusCode() == 200) {
                in = gm.getResponseBodyAsStream();
                if (!this.output.getParentFile().exists()) {
                    this.output.getParentFile().mkdirs();
                }
                out = new FileOutputStream(this.output);
                IOUtil.copy((InputStream)in, (OutputStream)out);
                ((OutputStream)out).close();
                out = null;
                in.close();
                in = null;
                this.getLog().debug((CharSequence)"Downloading from JIRA was successful");
            } else {
                this.getLog().warn((CharSequence)("Downloading from JIRA failed. Received: [" + gm.getStatusCode() + "]"));
            }
            IOUtil.close((OutputStream)out);
        }
        catch (HttpException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)"Error downloading issues from JIRA:", (Throwable)e);
                return;
            }
            this.getLog().error((CharSequence)("Error downloading issues from JIRA url: " + e.getLocalizedMessage()));
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (IOException e2) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().error((CharSequence)"Error downloading issues from JIRA:", (Throwable)e2);
                    return;
                }
                this.getLog().error((CharSequence)("Error downloading issues from JIRA. Cause is " + e2.getLocalizedMessage()));
                return;
            }
        }
        finally {
            IOUtil.close(out);
            IOUtil.close(in);
        }
        IOUtil.close((InputStream)in);
        return;
    }

    @Override
    public List<Issue> getIssueList() throws MojoExecutionException {
        if (this.output.isFile()) {
            JiraXML jira = new JiraXML(this.log, this.jiraDatePattern);
            jira.parseXML(this.output);
            this.getLog().info((CharSequence)("The JIRA version is '" + jira.getJiraVersion() + "'"));
            return jira.getIssueList();
        }
        this.getLog().warn((CharSequence)("JIRA file " + this.output.getPath() + " doesn't exist."));
        return Collections.emptyList();
    }
}

