/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.task.AddDirectoryTask;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.format.ReaderFormatter;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.assembly.utils.TypeConversionUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.Os;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddFileSetsTask {
    private final List<FileSet> fileSets;
    private Logger logger;
    private MavenProject project;
    private MavenProject moduleProject;

    public AddFileSetsTask(List<FileSet> fileSets) {
        this.fileSets = fileSets;
    }

    public AddFileSetsTask(FileSet ... fileSets) {
        this.fileSets = new ArrayList<FileSet>(Arrays.asList(fileSets));
    }

    public void execute(Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        File archiveBaseDir = configSource.getArchiveBaseDirectory();
        if (archiveBaseDir != null) {
            if (!archiveBaseDir.exists()) {
                throw new ArchiveCreationException("The archive base directory '" + archiveBaseDir.getAbsolutePath() + "' does not exist");
            }
            if (!archiveBaseDir.isDirectory()) {
                throw new ArchiveCreationException("The archive base directory '" + archiveBaseDir.getAbsolutePath() + "' exists, but it is not a directory");
            }
        }
        for (FileSet fileSet : this.fileSets) {
            this.addFileSet(fileSet, archiver, configSource, archiveBaseDir);
        }
    }

    void addFileSet(FileSet fileSet, Archiver archiver, AssemblerConfigurationSource configSource, File archiveBaseDir) throws AssemblyFormattingException, ArchiveCreationException {
        this.checkLogger();
        if (this.project == null) {
            this.project = configSource.getProject();
        }
        File basedir = this.project.getBasedir();
        String destDirectory = fileSet.getOutputDirectory();
        if (destDirectory == null) {
            destDirectory = fileSet.getDirectory();
        }
        this.warnForPlatformSpecifics(destDirectory);
        destDirectory = AssemblyFormatUtils.getOutputDirectory(destDirectory, configSource.getFinalName(), configSource, AssemblyFormatUtils.moduleProjectInterpolator(this.moduleProject), AssemblyFormatUtils.artifactProjectInterpolator(this.project));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("FileSet[" + destDirectory + "]" + " dir perms: " + Integer.toString(archiver.getOverrideDirectoryMode(), 8) + " file perms: " + Integer.toString(archiver.getOverrideFileMode(), 8) + (fileSet.getLineEnding() == null ? "" : " lineEndings: " + fileSet.getLineEnding()));
        }
        this.logger.debug("The archive base directory is '" + archiveBaseDir + "'");
        File fileSetDir = this.getFileSetDirectory(fileSet, basedir, archiveBaseDir);
        if (fileSetDir.exists()) {
            int fileMode;
            InputStreamTransformer fileSetTransformers = ReaderFormatter.getFileSetTransformers(configSource, fileSet.isFiltered(), fileSet.getLineEnding());
            if (fileSetTransformers == null) {
                this.logger.debug("NOT reformatting any files in " + fileSetDir);
            }
            if (fileSetDir.getPath().equals(File.separator)) {
                throw new AssemblyFormattingException("Your assembly descriptor specifies a directory of " + File.separator + ", which is your *entire* file system.\nThese are not the files you are looking for");
            }
            AddDirectoryTask task = new AddDirectoryTask(fileSetDir, fileSetTransformers);
            int dirMode = TypeConversionUtils.modeToInt(fileSet.getDirectoryMode(), this.logger);
            if (dirMode != -1) {
                task.setDirectoryMode(dirMode);
            }
            if ((fileMode = TypeConversionUtils.modeToInt(fileSet.getFileMode(), this.logger)) != -1) {
                task.setFileMode(fileMode);
            }
            task.setUseDefaultExcludes(fileSet.isUseDefaultExcludes());
            List<String> excludes = fileSet.getExcludes();
            excludes.add("**/*.filtered");
            excludes.add("**/*.formatted");
            task.setExcludes(excludes);
            task.setIncludes(fileSet.getIncludes());
            task.setOutputDirectory(destDirectory);
            task.execute(archiver);
        }
    }

    private void warnForPlatformSpecifics(String destDirectory) {
        if (Os.isFamily((String)"windows")) {
            if (AddFileSetsTask.isLinuxRootReference(destDirectory)) {
                this.logger.error("OS=Windows and the assembly descriptor contains a *nix-specific root-relative-reference (starting with slash) " + destDirectory);
            } else if (AddFileSetsTask.isWindowsPath(destDirectory)) {
                this.logger.warn("The assembly descriptor contains a *nix-specific root-relative-reference (starting with slash). This is non-portable and will fail on windows " + destDirectory);
            }
        } else if (AddFileSetsTask.isWindowsPath(destDirectory)) {
            this.logger.error("OS=Non-Windows and the assembly descriptor contains a windows-specific directory reference (with a drive letter) " + destDirectory);
        } else if (AddFileSetsTask.isLinuxRootReference(destDirectory)) {
            this.logger.warn("The assembly descriptor contains a filesystem-root relative reference,which is not cross platform compatible " + destDirectory);
        }
    }

    static boolean isWindowsPath(String destDirectory) {
        return destDirectory != null && destDirectory.length() >= 2 && destDirectory.charAt(1) == ':';
    }

    static boolean isLinuxRootReference(String destDirectory) {
        return destDirectory != null && destDirectory.startsWith("/");
    }

    File getFileSetDirectory(FileSet fileSet, File basedir, File archiveBaseDir) throws ArchiveCreationException, AssemblyFormattingException {
        File fileSetDir;
        String sourceDirectory = fileSet.getDirectory();
        if (sourceDirectory == null || sourceDirectory.trim().length() < 1) {
            sourceDirectory = basedir.getAbsolutePath();
        }
        if (archiveBaseDir == null) {
            fileSetDir = new File(sourceDirectory);
            if (!fileSetDir.isAbsolute()) {
                fileSetDir = new File(basedir, sourceDirectory);
            }
        } else {
            fileSetDir = new File(archiveBaseDir, sourceDirectory);
        }
        return fileSetDir;
    }

    private void checkLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(1, "AddFileSetsTask-internal");
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setModuleProject(MavenProject moduleProject) {
        this.moduleProject = moduleProject;
    }
}

