/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugin.assembly.utils.LineEndings;
import org.apache.maven.plugin.assembly.utils.LineEndingsUtils;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenReaderFilterRequest;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReaderFormatter {
    private static Reader createReaderFilter(@Nonnull Reader source, String escapeString, List<String> delimiters, AssemblerConfigurationSource configSource, boolean isPropertiesFile) throws IOException {
        try {
            MavenReaderFilterRequest filterRequest = new MavenReaderFilterRequest(source, true, configSource.getProject(), configSource.getFilters(), isPropertiesFile, null, configSource.getMavenSession(), null);
            filterRequest.setEscapeString(escapeString);
            if (delimiters != null && !delimiters.isEmpty()) {
                LinkedHashSet<String> delims = new LinkedHashSet<String>();
                for (String delim : delimiters) {
                    if (delim == null) {
                        delims.add("${*}");
                        continue;
                    }
                    delims.add(delim);
                }
                filterRequest.setDelimiters(delims);
            } else {
                filterRequest.setDelimiters(filterRequest.getDelimiters());
            }
            filterRequest.setInjectProjectBuildFilters(configSource.isIncludeProjectBuildFilters());
            return configSource.getMavenReaderFilter().filter(filterRequest);
        }
        catch (MavenFilteringException e) {
            IOException ioe = new IOException("Error filtering file '" + source + "': " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Nullable
    public static InputStreamTransformer getFileSetTransformers(final AssemblerConfigurationSource configSource, final boolean isFiltered, String fileSetLineEnding) throws AssemblyFormattingException {
        boolean transformLineEndings;
        final LineEndings lineEndingToUse = LineEndingsUtils.getLineEnding(fileSetLineEnding);
        boolean bl = transformLineEndings = !LineEndings.keep.equals((Object)lineEndingToUse);
        if (transformLineEndings || isFiltered) {
            return new InputStreamTransformer(){

                public InputStream transform(PlexusIoResource plexusIoResource, InputStream inputStream) throws IOException {
                    InputStream result = inputStream;
                    if (isFiltered) {
                        String encoding = configSource.getEncoding();
                        InputStreamReader source = encoding != null ? new InputStreamReader(inputStream, encoding) : new InputStreamReader(inputStream);
                        boolean isPropertyFile = AssemblyFileUtils.isPropertyFile(plexusIoResource.getName());
                        Reader filtered = ReaderFormatter.createReaderFilter(source, configSource.getEscapeString(), configSource.getDelimiters(), configSource, isPropertyFile);
                        Object object = result = encoding != null ? new ReaderInputStream(filtered, encoding) : new ReaderInputStream(filtered);
                    }
                    if (transformLineEndings) {
                        result = LineEndingsUtils.lineEndingConverter(result, lineEndingToUse);
                    }
                    return result;
                }
            };
        }
        return null;
    }
}

