/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.test.plugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.test.plugin.TestToolsException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public class BuildTool
implements Initializable,
Disposable {
    public static final String ROLE = BuildTool.class.getName();
    private Invoker mavenInvoker;

    public InvocationResult executeMaven(File pom, Properties properties, List goals, File buildLogFile) throws TestToolsException {
        InvocationRequest request = this.createBasicInvocationRequest(pom, properties, goals, buildLogFile);
        return this.executeMaven(request);
    }

    public InvocationResult executeMaven(InvocationRequest request) throws TestToolsException {
        try {
            InvocationResult invocationResult = this.mavenInvoker.execute(request);
            return invocationResult;
        }
        catch (MavenInvocationException e) {
            throw new TestToolsException("Error executing maven.", e);
        }
        finally {
            this.closeHandlers(request);
        }
    }

    private void startInvoker() throws IOException {
        if (this.mavenInvoker == null) {
            Properties envars;
            String mavenHome;
            this.mavenInvoker = new DefaultInvoker();
            if (System.getProperty("maven.home") == null && (mavenHome = (envars = CommandLineUtils.getSystemEnvVars()).getProperty("M2_HOME")) != null) {
                this.mavenInvoker.setMavenHome(new File(mavenHome));
            }
        }
    }

    private void closeHandlers(InvocationRequest request) {
        InvocationOutputHandler errHandler;
        InvocationOutputHandler outHandler = request.getOutputHandler(null);
        if (outHandler != null && outHandler instanceof LoggerHandler) {
            ((LoggerHandler)outHandler).close();
        }
        if ((errHandler = request.getErrorHandler(null)) != null && (outHandler == null || errHandler != outHandler) && errHandler instanceof LoggerHandler) {
            ((LoggerHandler)errHandler).close();
        }
    }

    public InvocationRequest createBasicInvocationRequest(File pom, Properties properties, List goals, File buildLogFile) {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(pom);
        request.setGoals(goals);
        request.setProperties(properties);
        LoggerHandler handler = new LoggerHandler(buildLogFile);
        request.setOutputHandler((InvocationOutputHandler)handler);
        request.setErrorHandler((InvocationOutputHandler)handler);
        return request;
    }

    public void initialize() throws InitializationException {
        try {
            this.startInvoker();
        }
        catch (IOException e) {
            throw new InitializationException("Error detecting maven home.", (Throwable)e);
        }
    }

    public void dispose() {
    }

    private static final class LoggerHandler
    implements InvocationOutputHandler {
        private static final String LS = System.getProperty("line.separator");
        private final File output;
        private FileWriter writer;

        LoggerHandler(File logFile) {
            this.output = logFile;
        }

        public void consumeLine(String line) {
            if (this.writer == null) {
                try {
                    this.writer = new FileWriter(this.output);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to open build log: " + this.output + "\n\nError: " + e.getMessage());
                }
            }
            try {
                this.writer.write(line + LS);
                this.writer.flush();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to write to build log: " + this.output + " output:\n\n'" + line + "'\n\nError: " + e.getMessage());
            }
        }

        void close() {
            IOUtil.close((Writer)this.writer);
        }
    }
}

